/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ab;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.n;
import com.google.android.gms.analytics.q;
import com.google.android.gms.analytics.x;
import com.google.android.gms.analytics.y;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class ah
implements n {
    private final String jr;
    private final HttpClient js;
    private final Context mContext;
    private GoogleAnalytics gC;
    private URL jt;

    ah(HttpClient httpClient, GoogleAnalytics googleAnalytics, Context context) {
        this.mContext = context.getApplicationContext();
        this.jr = this.a("GoogleAnalytics", "3.0", Build.VERSION.RELEASE, ak.a(Locale.getDefault()), Build.MODEL, Build.ID);
        this.js = httpClient;
        this.gC = googleAnalytics;
    }

    ah(HttpClient httpClient, Context context) {
        this(httpClient, GoogleAnalytics.getInstance(context), context);
    }

    @Override
    public boolean K() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            aa.o("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public int a(List<x> list, ab ab2, boolean bl2) {
        int n2 = 0;
        int n3 = Math.min(list.size(), 40);
        ab2.c("_hr", list.size());
        int n4 = 0;
        URL uRL = null;
        boolean bl3 = true;
        for (int i2 = 0; i2 < n3; ++i2) {
            x x2 = list.get(i2);
            URL uRL2 = this.a(x2);
            if (uRL2 == null) {
                if (aa.ay()) {
                    aa.p("No destination: discarding hit: " + x2.at());
                } else {
                    aa.p("No destination: discarding hit.");
                }
                ++n2;
                ++n4;
                continue;
            }
            uRL = uRL2;
            HttpHost httpHost = new HttpHost(uRL2.getHost(), uRL2.getPort(), uRL2.getProtocol());
            String string = uRL2.getPath();
            String string2 = TextUtils.isEmpty((CharSequence)x2.at()) ? "" : y.a(x2, System.currentTimeMillis());
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.c(string2, string);
            if (httpEntityEnclosingRequest == null) {
                ++n2;
                ++n4;
                continue;
            }
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            if (aa.ay()) {
                this.a(httpEntityEnclosingRequest);
            }
            if (string2.length() > 8192) {
                aa.p("Hit too long (> 8192 bytes)--not sent");
                ++n4;
            } else if (this.gC.isDryRunEnabled()) {
                aa.n("Dry run enabled. Hit not actually sent.");
            } else {
                try {
                    if (bl3) {
                        q.f(this.mContext);
                        bl3 = false;
                    }
                    HttpResponse httpResponse = this.js.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
                    int n5 = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null) {
                        httpEntity.consumeContent();
                    }
                    if (n5 != 200) {
                        aa.p("Bad response: " + httpResponse.getStatusLine().getStatusCode());
                    }
                }
                catch (ClientProtocolException clientProtocolException) {
                    aa.p("ClientProtocolException sending hit; discarding hit...");
                    ab2.c("_hd", n4);
                }
                catch (IOException iOException) {
                    aa.p("Exception sending hit: " + iOException.getClass().getSimpleName());
                    aa.p(iOException.getMessage());
                    ab2.c("_de", 1);
                    ab2.c("_hd", n4);
                    ab2.c("_hs", n2);
                    this.a(ab2, uRL, bl3);
                    return n2;
                }
            }
            ab2.c("_td", string2.getBytes().length);
            ++n2;
        }
        ab2.c("_hd", n4);
        ab2.c("_hs", n2);
        if (bl2) {
            this.a(ab2, uRL, bl3);
        }
        return n2;
    }

    private void a(ab ab2, URL uRL, boolean bl2) {
        String string = ab2.az();
        if (TextUtils.isEmpty((CharSequence)string) || !this.aG()) {
            return;
        }
        if (uRL == null) {
            try {
                uRL = this.jt != null ? this.jt : new URL("https://ssl.google-analytics.com/collect");
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
        }
        HttpHost httpHost = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
        try {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.c(ab2.az(), uRL.getPath());
            if (httpEntityEnclosingRequest == null) {
                return;
            }
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            if (aa.ay()) {
                this.a(httpEntityEnclosingRequest);
            }
            if (bl2) {
                q.f(this.mContext);
                bl2 = false;
            }
            HttpResponse httpResponse = this.js.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
            int n2 = httpResponse.getStatusLine().getStatusCode();
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                httpEntity.consumeContent();
            }
            if (n2 != 200) {
                aa.p("Bad response: " + httpResponse.getStatusLine().getStatusCode());
            }
        }
        catch (ClientProtocolException clientProtocolException) {
            aa.p("ClientProtocolException sending monitoring hit.");
        }
        catch (IOException iOException) {
            aa.p("Exception sending monitoring hit: " + iOException.getClass().getSimpleName());
            aa.p(iOException.getMessage());
            return;
        }
    }

    boolean aG() {
        return Math.random() * 100.0 <= 1.0;
    }

    private HttpEntityEnclosingRequest c(String string, String string2) {
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest;
        if (TextUtils.isEmpty((CharSequence)string)) {
            aa.p("Empty hit, discarding.");
            return null;
        }
        String string3 = string2 + "?" + string;
        if (string3.length() < 2036) {
            basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("GET", string3);
        } else {
            basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("POST", string2);
            try {
                basicHttpEntityEnclosingRequest.setEntity((HttpEntity)new StringEntity(string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                aa.p("Encoding error, discarding hit");
                return null;
            }
        }
        basicHttpEntityEnclosingRequest.addHeader("User-Agent", this.jr);
        return basicHttpEntityEnclosingRequest;
    }

    private void a(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Header header : httpEntityEnclosingRequest.getAllHeaders()) {
            stringBuffer.append(header.toString()).append("\n");
        }
        stringBuffer.append(httpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
        if (httpEntityEnclosingRequest.getEntity() != null) {
            try {
                int n2;
                InputStream inputStream = httpEntityEnclosingRequest.getEntity().getContent();
                if (inputStream != null && (n2 = inputStream.available()) > 0) {
                    byte[] byArray = new byte[n2];
                    inputStream.read(byArray);
                    stringBuffer.append("POST:\n");
                    stringBuffer.append(new String(byArray)).append("\n");
                }
            }
            catch (IOException iOException) {
                aa.o("Error Writing hit to log...");
            }
        }
        aa.o(stringBuffer.toString());
    }

    String a(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    URL a(x x2) {
        if (this.jt != null) {
            return this.jt;
        }
        String string = x2.aw();
        try {
            return new URL("http:".equals(string) ? "http://www.google-analytics.com/collect" : "https://ssl.google-analytics.com/collect");
        }
        catch (MalformedURLException malformedURLException) {
            aa.m("Error trying to parse the hardcoded host url. This really shouldn't happen.");
            return null;
        }
    }

    @Override
    public void g(String string) {
        try {
            this.jt = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.jt = null;
        }
    }
}

