/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ab;
import com.google.android.gms.analytics.ah;
import com.google.android.gms.analytics.d;
import com.google.android.gms.analytics.e;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.n;
import com.google.android.gms.analytics.p;
import com.google.android.gms.analytics.x;
import com.google.android.gms.analytics.y;
import com.google.android.gms.internal.g;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class ac
implements d {
    private static final String jg = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private final a jh;
    private volatile n ji;
    private final e gt;
    private final Context mContext;
    private final String jj;
    private ab jk;
    private long jl;
    private final int jm;
    private i gL;

    ac(e e2, Context context) {
        this(e2, context, "google_analytics_v4.db", 2000);
    }

    ac(e e2, Context context, String string, int n2) {
        this.mContext = context.getApplicationContext();
        this.jj = string;
        this.gt = e2;
        this.gL = new i(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.jh = new a(this.mContext, this.jj);
        this.ji = new ah((HttpClient)new DefaultHttpClient(), this.mContext);
        this.jl = 0L;
        this.jm = n2;
    }

    @Override
    public void a(long l2) {
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for clearHits");
        if (sQLiteDatabase != null) {
            if (l2 == 0L) {
                sQLiteDatabase.delete("hits2", null, null);
            } else {
                String[] stringArray = new String[]{Long.valueOf(l2).toString()};
                sQLiteDatabase.delete("hits2", "hit_app_id = ?", stringArray);
            }
            this.gt.b(this.aC() == 0);
        }
    }

    @Override
    public void a(Map<String, String> map, long l2, String string, Collection<g> collection) {
        this.aB();
        this.aA();
        this.a(map, collection);
        this.a(map, l2, string);
    }

    private void a(Map<String, String> map, Collection<g> collection) {
        String string = "&_v".substring(1);
        if (collection != null) {
            for (g g2 : collection) {
                if (!"appendVersion".equals(g2.getId())) continue;
                map.put(string, g2.getValue());
                break;
            }
        }
    }

    private void aA() {
        int n2 = this.aC() - this.jm + 1;
        if (n2 > 0) {
            List<String> list = this.j(n2);
            aa.o("Store full, deleting " + list.size() + " hits to make room.");
            this.a(list.toArray(new String[0]));
        }
    }

    private void a(Map<String, String> map, long l2, String string) {
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", ac.g(map));
        contentValues.put("hit_time", Long.valueOf(l2));
        long l3 = 0L;
        if (map.containsKey("AppUID")) {
            try {
                l3 = Long.parseLong(map.get("AppUID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        contentValues.put("hit_app_id", Long.valueOf(l3));
        if (string == null) {
            string = "http://www.google-analytics.com/collect";
        }
        if (string.length() == 0) {
            aa.p("Empty path: not sending hit");
            return;
        }
        contentValues.put("hit_url", string);
        try {
            sQLiteDatabase.insert("hits2", null, contentValues);
            this.gt.b(false);
        }
        catch (SQLiteException sQLiteException) {
            aa.p("Error storing hit");
        }
    }

    static String g(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(y.encode(entry.getKey()) + "=" + y.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> j(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            aa.p("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<x> k(int n2) {
        ArrayList<x> arrayList = new ArrayList<x>();
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    x x2 = new x(null, cursor.getLong(0), cursor.getLong(1));
                    arrayList.add(x2);
                } while (cursor.moveToNext());
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_string", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((x)arrayList.get(n3)).k(cursor.getString(1));
                        ((x)arrayList.get(n3)).l(cursor.getString(2));
                    } else {
                        aa.p(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((x)arrayList.get(n3)).au()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            aa.p("Error in peekHits fetching hitString: " + sQLiteException.getMessage());
            ArrayList<x> arrayList2 = new ArrayList<x>();
            boolean bl2 = false;
            for (x x3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)x3.at())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList2.add(x3);
            }
            ArrayList<x> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int aB() {
        long l2 = this.gL.currentTimeMillis();
        if (l2 <= this.jl + 86400000L) {
            return 0;
        }
        this.jl = l2;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.gL.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("hits2", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.gt.b(this.aC() == 0);
        return n2;
    }

    @Deprecated
    void a(Collection<x> collection) {
        if (collection == null || collection.isEmpty()) {
            aa.p("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (x x2 : collection) {
            stringArray[n2++] = String.valueOf(x2.au());
        }
        this.a(stringArray);
    }

    void a(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            aa.p("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("hits2", string, stringArray);
            this.gt.b(this.aC() == 0);
        }
        catch (SQLiteException sQLiteException) {
            aa.p("Error deleting hits " + stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int aC() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.q("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        return n2;
    }

    @Override
    public void y() {
        int n2;
        aa.o("Dispatch running...");
        if (!this.ji.K()) {
            return;
        }
        List<x> list = this.k(40);
        if (list.isEmpty()) {
            aa.o("...nothing to dispatch");
            this.gt.b(true);
            return;
        }
        if (this.jk == null) {
            this.jk = new ab("_t=dispatch&_v=ma4.0.2", true);
        }
        boolean bl2 = (n2 = this.aC()) <= list.size();
        int n3 = this.ji.a(list, this.jk, bl2);
        aa.o("sent " + n3 + " of " + list.size() + " hits");
        this.a(list.subList(0, Math.min(n3, list.size())));
        if (n3 == list.size() && this.aC() > 0) {
            GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        } else {
            this.jk = null;
        }
    }

    @Override
    public n z() {
        return this.ji;
    }

    private SQLiteDatabase q(String string) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.jh.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            aa.p(string);
            return null;
        }
        return sQLiteDatabase;
    }

    class a
    extends SQLiteOpenHelper {
        private boolean jo;
        private long jp;

        a(Context context, String string) {
            super(context, string, null, 1);
            this.jp = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string, SQLiteDatabase sQLiteDatabase) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.jo && this.jp + 3600000L > ac.this.gL.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.jo = true;
            this.jp = ac.this.gL.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                ac.this.mContext.getDatabasePath(ac.this.jj).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.jo = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.a("hits2", db2)) {
                db2.execSQL(jg);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            boolean bl2;
            HashSet<String> hashSet = new HashSet<String>();
            try (Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM hits2 WHERE 0", null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_string") && hashSet.remove("hit_time"))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl3 = bl2 = !hashSet.remove("hit_app_id");
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (bl2) {
                sQLiteDatabase.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            p.h(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }
}

