/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.u;
import com.google.android.gms.analytics.z;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker {
    private final TrackerHandler jv;
    private Context mContext;
    private final Map<String, String> jw = new HashMap<String, String>();
    private ad jx;
    private final h jy;
    private final ae jz;
    private final g jA;
    private boolean jB;
    private a jC;
    private aj jD;
    private ExceptionReporter jE;

    Tracker(String trackingId, TrackerHandler handler, Context context) {
        this(trackingId, handler, h.D(), ae.aE(), g.C(), new z("tracking"), context);
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ae screenResolutionDefaultProvider, g appFieldsDefaultProvider, ad rateLimiter, Context context) {
        this.jv = handler;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        if (trackingId != null) {
            this.jw.put("&tid", trackingId);
        }
        this.jw.put("useSecure", "1");
        this.jy = clientIdDefaultProvider;
        this.jz = screenResolutionDefaultProvider;
        this.jA = appFieldsDefaultProvider;
        this.jw.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.jx = rateLimiter;
        this.jC = new a();
        this.enableAdvertisingIdCollection(false);
    }

    void a(aj aj2) {
        String string;
        aa.o("Loading Tracker config values.");
        this.jD = aj2;
        if (this.jD.aN()) {
            string = this.jD.aO();
            this.set("&tid", string);
            aa.o("[Tracker] trackingId loaded: " + string);
        }
        if (this.jD.aP()) {
            string = Double.toString(this.jD.aQ());
            this.set("&sf", string);
            aa.o("[Tracker] sample frequency loaded: " + string);
        }
        if (this.jD.aR()) {
            this.setSessionTimeout(this.jD.getSessionTimeout());
            aa.o("[Tracker] session timeout loaded: " + this.aH());
        }
        if (this.jD.aS()) {
            this.enableAutoActivityTracking(this.jD.aT());
            aa.o("[Tracker] auto activity tracking loaded: " + this.aI());
        }
        if (this.jD.aU()) {
            if (this.jD.aV()) {
                this.set("&aip", "1");
                aa.o("[Tracker] anonymize ip loaded: true");
            }
            aa.o("[Tracker] anonymize ip loaded: false");
        }
        this.enableExceptionReporting(this.jD.aW());
    }

    public void enableExceptionReporting(boolean enabled) {
        if (this.jB == enabled) {
            return;
        }
        this.jB = enabled;
        if (enabled) {
            this.jE = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), this.mContext);
            Thread.setDefaultUncaughtExceptionHandler(this.jE);
            aa.o("Uncaught exceptions will be reported to Google Analytics.");
        } else {
            if (this.jE != null) {
                Thread.setDefaultUncaughtExceptionHandler(this.jE.L());
            } else {
                Thread.setDefaultUncaughtExceptionHandler(null);
            }
            aa.o("Uncaught exceptions will not be reported to Google Analytics.");
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.jC.setSessionTimeout(sessionTimeout * 1000L);
    }

    long aH() {
        return this.jC.aH();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.jC.enableAutoActivityTracking(enabled);
    }

    boolean aI() {
        return this.jC.aI();
    }

    public void send(Map<String, String> params) {
        String string;
        u.ad().a(u.a.hy);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.jw);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            aa.p(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string = (String)hashMap.get("&t")))) {
            aa.p(String.format("Missing hit type (%s) parameter.", "&t"));
            string = "";
        }
        if (this.jC.aJ()) {
            hashMap.put("&sc", "start");
        }
        if ("screenview".equals(string = string.toLowerCase()) || "pageview".equals(string) || "appview".equals(string) || TextUtils.isEmpty((CharSequence)string)) {
            int n2 = Integer.parseInt(this.jw.get("&a"));
            n2 = ++n2 >= Integer.MAX_VALUE ? 1 : n2;
            this.jw.put("&a", Integer.toString(n2));
        }
        if (!(string.equals("transaction") || string.equals("item") || this.jx.ax())) {
            aa.p("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.jv.a(hashMap);
        }
    }

    public String get(String key) {
        u.ad().a(u.a.hw);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.jw.containsKey(key)) {
            return this.jw.get(key);
        }
        if (key.equals("&ul")) {
            return ak.a(Locale.getDefault());
        }
        if (this.jy != null && this.jy.d(key)) {
            return this.jy.getValue(key);
        }
        if (this.jz != null && this.jz.d(key)) {
            return this.jz.getValue(key);
        }
        if (this.jA != null && this.jA.d(key)) {
            return this.jA.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        com.google.android.gms.internal.aa.a(key, (Object)"Key should be non-null");
        u.ad().a(u.a.hx);
        this.jw.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", ak.e(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            aa.p("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", ak.e(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.jw.put("&ate", null);
            this.jw.put("&adid", null);
        } else {
            if (this.jw.containsKey("&ate")) {
                this.jw.remove("&ate");
            }
            if (this.jw.containsKey("&adid")) {
                this.jw.remove("&adid");
            }
        }
    }

    private class a
    implements GoogleAnalytics.a {
        private boolean jF = false;
        private int jG = 0;
        private long jH = -1L;
        private boolean jI = false;
        private long jJ;
        private i gL;

        public a() {
            this.gL = new i(){

                @Override
                public long currentTimeMillis() {
                    return System.currentTimeMillis();
                }
            };
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.jH = sessionTimeout;
            this.aK();
        }

        public long aH() {
            return this.jH;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.jF = enabled;
            this.aK();
        }

        public boolean aI() {
            return this.jF;
        }

        public boolean aJ() {
            boolean bl2 = this.jI;
            this.jI = false;
            return bl2;
        }

        private void aK() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.ar();
            if (googleAnalytics == null) {
                aa.m("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.jH >= 0L || this.jF) {
                googleAnalytics.a(Tracker.this.jC);
            } else {
                googleAnalytics.b(Tracker.this.jC);
            }
        }

        @Override
        public void c(Activity activity) {
            u.ad().a(u.a.iv);
            if (this.jG == 0 && this.aL()) {
                this.jI = true;
            }
            ++this.jG;
            if (this.jF) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                u.ad().d(true);
                Tracker.this.set("&cd", Tracker.this.jD != null ? Tracker.this.jD.e(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                u.ad().d(false);
            }
        }

        @Override
        public void d(Activity activity) {
            u.ad().a(u.a.iw);
            --this.jG;
            this.jG = Math.max(0, this.jG);
            if (this.jG == 0) {
                this.jJ = this.gL.currentTimeMillis();
            }
        }

        boolean aL() {
            return this.gL.currentTimeMillis() >= this.jJ + Math.max(1000L, this.jH);
        }
    }
}

