/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.aa;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class StandardExceptionParser
implements ExceptionParser {
    private final TreeSet<String> ju = new TreeSet();

    public StandardExceptionParser(Context context, Collection<String> additionalPackages) {
        this.setIncludedPackages(context, additionalPackages);
    }

    public void setIncludedPackages(Context context, Collection<String> additionalPackages) {
        this.ju.clear();
        HashSet<String> hashSet = new HashSet<String>();
        if (additionalPackages != null) {
            hashSet.addAll(additionalPackages);
        }
        if (context != null) {
            try {
                String string = context.getApplicationContext().getPackageName();
                this.ju.add(string);
                String string2 = context.getApplicationContext().getPackageManager().getPackageInfo(string, 15);
                ActivityInfo[] activityInfoArray = ((PackageInfo)string2).activities;
                if (activityInfoArray != null) {
                    for (ActivityInfo activityInfo : activityInfoArray) {
                        hashSet.add(activityInfo.packageName);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                aa.n("No package found");
            }
        }
        for (String string2 : hashSet) {
            boolean bl2 = true;
            for (String string : this.ju) {
                if (!string2.startsWith(string)) {
                    if (!string.startsWith(string2)) break;
                    this.ju.remove(string);
                    break;
                }
                bl2 = false;
            }
            if (!bl2) continue;
            this.ju.add(string2);
        }
    }

    protected Throwable getCause(Throwable t2) {
        Throwable throwable = t2;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    protected StackTraceElement getBestStackTraceElement(Throwable t2) {
        StackTraceElement[] stackTraceElementArray = t2.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.getClassName();
            for (String string2 : this.ju) {
                if (!string.startsWith(string2)) continue;
                return stackTraceElement;
            }
        }
        return stackTraceElementArray[0];
    }

    protected String getDescription(Throwable cause, StackTraceElement element, String threadName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cause.getClass().getSimpleName());
        if (element != null) {
            String[] stringArray = element.getClassName().split("\\.");
            String string = "unknown";
            if (stringArray != null && stringArray.length > 0) {
                string = stringArray[stringArray.length - 1];
            }
            stringBuilder.append(String.format(" (@%s:%s:%s)", string, element.getMethodName(), element.getLineNumber()));
        }
        if (threadName != null) {
            stringBuilder.append(String.format(" {%s}", threadName));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDescription(String threadName, Throwable t2) {
        return this.getDescription(this.getCause(t2), this.getBestStackTraceElement(this.getCause(t2)), threadName);
    }
}

