/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.StandardExceptionParser;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.aa;
import java.util.ArrayList;

public class ExceptionReporter
implements Thread.UncaughtExceptionHandler {
    private final Thread.UncaughtExceptionHandler gf;
    private final Tracker gg;
    private final Context mContext;
    private ExceptionParser gh;

    public ExceptionReporter(Tracker tracker, Thread.UncaughtExceptionHandler originalHandler, Context context) {
        if (tracker == null) {
            throw new NullPointerException("tracker cannot be null");
        }
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.gf = originalHandler;
        this.gg = tracker;
        this.gh = new StandardExceptionParser(context, new ArrayList<String>());
        this.mContext = context.getApplicationContext();
        aa.o("ExceptionReporter created, original handler is " + (originalHandler == null ? "null" : originalHandler.getClass().getName()));
    }

    public ExceptionParser getExceptionParser() {
        return this.gh;
    }

    public void setExceptionParser(ExceptionParser exceptionParser) {
        this.gh = exceptionParser;
    }

    @Override
    public void uncaughtException(Thread t2, Throwable e2) {
        String string = "UncaughtException";
        if (this.gh != null) {
            String string2 = t2 != null ? t2.getName() : null;
            string = this.gh.getDescription(string2, e2);
        }
        aa.o("Tracking Exception: " + string);
        this.gg.send(new HitBuilders.ExceptionBuilder().setDescription(string).setFatal(true).build());
        GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        if (this.gf != null) {
            aa.o("Passing exception to original handler.");
            this.gf.uncaughtException(t2, e2);
        }
    }

    Thread.UncaughtExceptionHandler L() {
        return this.gf;
    }
}

