/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GoogleCloudMessaging {
    private static String zzakT = null;
    public static int zzakU = 5000000;
    public static int zzakV = 6500000;
    public static int zzakW = 7000000;
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    public static final String REGISTRATION_ID = "registration_id";
    public static final String MESSAGE_TYPE_DELETED = "deleted_messages";
    public static final String MESSAGE_TYPE_MESSAGE = "gcm";
    public static final String MESSAGE_TYPE_SEND_ERROR = "send_error";
    static GoogleCloudMessaging zzakX;
    private Context zzlN;
    private PendingIntent zzakY;
    private Map<String, Handler> zzakZ;
    private static final AtomicInteger zzala;
    private final BlockingQueue<Intent> zzalb = new LinkedBlockingQueue<Intent>();
    final Messenger zzalc;

    public static synchronized GoogleCloudMessaging getInstance(Context context) {
        if (zzakX == null) {
            zzakX = new GoogleCloudMessaging();
            GoogleCloudMessaging.zzakX.zzlN = context.getApplicationContext();
        }
        return zzakX;
    }

    public GoogleCloudMessaging() {
        this.zzakZ = Collections.synchronizedMap(new HashMap());
        this.zzalc = new Messenger(new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                Intent intent;
                if (msg == null || !(msg.obj instanceof Intent)) {
                    Log.w((String)"GCM", (String)"Dropping invalid message");
                }
                if ("com.google.android.c2dm.intent.REGISTRATION".equals((intent = (Intent)msg.obj).getAction())) {
                    GoogleCloudMessaging.this.zzalb.add(intent);
                } else if (!GoogleCloudMessaging.this.zzj(intent)) {
                    intent.setPackage(GoogleCloudMessaging.this.zzlN.getPackageName());
                    GoogleCloudMessaging.this.zzlN.sendBroadcast(intent);
                }
            }
        });
    }

    public void close() {
        this.zzpe();
    }

    public void send(String to, String msgId, Bundle data) throws IOException {
        this.send(to, msgId, -1L, data);
    }

    public void send(String to, String msgId, long timeToLive, Bundle data) throws IOException {
        this.zza(to, msgId, timeToLive, -1, data);
    }

    private void zza(String string, String string2, long l, int n, Bundle bundle) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        this.zzk(intent);
        intent.setPackage(GoogleCloudMessaging.zzZ(this.zzlN));
        intent.putExtra("google.to", string);
        intent.putExtra("google.message_id", string2);
        intent.putExtra("google.ttl", Long.toString(l));
        intent.putExtra("google.delay", Integer.toString(n));
        this.zzlN.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private boolean zzj(Intent intent) {
        String string = intent.getStringExtra("In-Reply-To");
        if (string == null && intent.hasExtra("error")) {
            string = intent.getStringExtra("google.message_id");
        }
        Handler handler = null;
        if (string != null && (handler = this.zzakZ.remove(string)) != null) {
            Message message = Message.obtain();
            message.obj = intent;
            return handler.sendMessage(message);
        }
        return false;
    }

    private String zzpd() {
        return "google.rpc" + String.valueOf(zzala.getAndIncrement());
    }

    public synchronized void unregister() throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        Intent intent = new Intent("com.google.android.c2dm.intent.UNREGISTER");
        intent.setPackage(GoogleCloudMessaging.zzZ(this.zzlN));
        intent.putExtra("google.messenger", (Parcelable)this.zzalc);
        this.zzk(intent);
        this.zzlN.startService(intent);
        Intent intent2 = null;
        try {
            intent2 = this.zzalb.poll(30000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
        this.zza(intent2, "unregistered");
    }

    public synchronized String register(String ... senderIds) throws IOException {
        String string = this.zzd(senderIds);
        Bundle bundle = new Bundle();
        bundle.putString("sender", string);
        Intent intent = this.zzt(bundle);
        return this.zza(intent, REGISTRATION_ID);
    }

    private Intent zzt(Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        int n = GoogleCloudMessaging.zzaa(this.zzlN);
        if (n < 0) {
            throw new IOException("Google Play Services missing");
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        Intent intent = new Intent("com.google.android.c2dm.intent.REGISTER");
        intent.setPackage(GoogleCloudMessaging.zzZ(this.zzlN));
        this.zzk(intent);
        String string = this.zzpd();
        intent.putExtra("google.message_id", string);
        intent.putExtras(bundle);
        intent.putExtra("google.messenger", (Parcelable)this.zzalc);
        this.zzlN.startService(intent);
        Intent intent2 = null;
        try {
            intent2 = this.zzalb.poll(30000L, TimeUnit.MILLISECONDS);
            return intent2;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    private String zza(Intent intent, String string) throws IOException {
        if (intent == null) {
            throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
        }
        String string2 = intent.getStringExtra(string);
        if (string2 != null) {
            return string2;
        }
        String string3 = intent.getStringExtra("error");
        if (string3 != null) {
            throw new IOException(string3);
        }
        throw new IOException(ERROR_SERVICE_NOT_AVAILABLE);
    }

    String zzd(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("No senderIds");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(',').append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getMessageType(Intent intent) {
        String string = intent.getAction();
        if (!"com.google.android.c2dm.intent.RECEIVE".equals(string)) {
            return null;
        }
        String string2 = intent.getStringExtra("message_type");
        if (string2 != null) {
            return string2;
        }
        return MESSAGE_TYPE_MESSAGE;
    }

    synchronized void zzk(Intent intent) {
        if (this.zzakY == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzakY = PendingIntent.getBroadcast((Context)this.zzlN, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzakY);
    }

    synchronized void zzpe() {
        if (this.zzakY != null) {
            this.zzakY.cancel();
            this.zzakY = null;
        }
    }

    public static String zzZ(Context context) {
        if (zzakT == null) {
            zzakT = "com.google.android.gms";
        }
        return zzakT;
    }

    public static int zzaa(Context context) {
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(GoogleCloudMessaging.zzZ(context), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    static {
        zzala = new AtomicInteger(1);
    }
}

