/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.PendingIntent;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.hq;
import com.google.android.gms.internal.ht;
import com.google.android.gms.plus.PlusOneButton;
import com.google.android.gms.plus.PlusOneDummyView;

public final class PlusOneButtonWithPopup
extends ViewGroup {
    private View DB;
    private int mSize;
    private int DC;
    private View.OnClickListener DH;
    private String iH;
    private String jG;

    public PlusOneButtonWithPopup(Context context) {
        this(context, null);
    }

    public PlusOneButtonWithPopup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.DC = PlusOneButton.getAnnotation(context, attrs);
        this.DB = new PlusOneDummyView(context, this.mSize);
        this.addView(this.DB);
    }

    private void eL() {
        if (this.DB != null) {
            this.removeView(this.DB);
        }
        this.DB = ht.a(this.getContext(), this.mSize, this.DC, this.iH, this.jG);
        if (this.DH != null) {
            this.setOnClickListener(this.DH);
        }
        this.addView(this.DB);
    }

    public void initialize(String url, String accountName) {
        eg.b(url, (Object)"Url must not be null");
        this.iH = url;
        this.jG = accountName;
        this.eL();
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.DH = onClickListener;
        this.DB.setOnClickListener(onClickListener);
    }

    public void setAnnotation(int annotation) {
        this.DC = annotation;
        this.eL();
    }

    public void setSize(int size) {
        this.mSize = size;
        this.eL();
    }

    public PendingIntent getResolution() {
        if (this.DB != null) {
            try {
                return this.eM().getResolution();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public void cancelClick() {
        if (this.DB != null) {
            try {
                this.eM().cancelClick();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void reinitialize() {
        if (this.DB != null) {
            try {
                this.eM().reinitialize();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private hq eM() throws RemoteException {
        IBinder iBinder = (IBinder)this.DB.getTag();
        hq hq2 = hq.a.aw(iBinder);
        if (hq2 == null) {
            if (Log.isLoggable((String)"PlusOneButtonWithPopup", (int)5)) {
                Log.w((String)"PlusOneButtonWithPopup", (String)"Failed to get PlusOneDelegate");
            }
            throw new RemoteException();
        }
        return hq2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = this.getPaddingLeft() + this.getPaddingRight();
        int n3 = this.getPaddingTop() + this.getPaddingBottom();
        this.DB.measure(this.c(widthMeasureSpec, n2), this.c(heightMeasureSpec, n3));
        this.setMeasuredDimension(this.DB.getMeasuredWidth() + n2, this.DB.getMeasuredHeight() + n3);
    }

    private int c(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        switch (n4) {
            case -2147483648: 
            case 0x40000000: {
                int n5 = View.MeasureSpec.getSize((int)n2) - n3;
                return View.MeasureSpec.makeMeasureSpec((int)n5, (int)n4);
            }
        }
        return n2;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.DB.layout(this.getPaddingLeft(), this.getPaddingTop(), right - left - this.getPaddingRight(), bottom - top - this.getPaddingBottom());
    }
}

