/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.ej;
import com.google.android.gms.internal.ht;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View DB;
    private int mSize;
    private int DC;
    private String iH;
    private int DD;
    private OnPlusOneClickListener DE;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.DC = PlusOneButton.getAnnotation(context, attrs);
        this.DD = -1;
        this.p(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attrs) {
        String string2 = ej.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "size", context, attrs, true, false, "PlusOneButton");
        return "SMALL".equalsIgnoreCase(string2) ? 0 : ("MEDIUM".equalsIgnoreCase(string2) ? 1 : ("TALL".equalsIgnoreCase(string2) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attrs) {
        String string2 = ej.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "annotation", context, attrs, true, false, "PlusOneButton");
        return "INLINE".equalsIgnoreCase(string2) ? 2 : ("NONE".equalsIgnoreCase(string2) ? 0 : 1);
    }

    private void p(Context context) {
        if (this.DB != null) {
            this.removeView(this.DB);
        }
        this.DB = ht.a(context, this.mSize, this.DC, this.iH, this.DD);
        this.setOnPlusOneClickListener(this.DE);
        this.addView(this.DB);
    }

    public void initialize(String url, int activityRequestCode) {
        eg.a(this.getContext() instanceof Activity, "To use this method, the PlusOneButton must be placed in an Activity. Use initialize(PlusClient, String, OnPlusOneClickListener).");
        this.iH = url;
        this.DD = activityRequestCode;
        this.p(this.getContext());
    }

    public void initialize(String url, OnPlusOneClickListener plusOneClickListener) {
        this.iH = url;
        this.DD = 0;
        this.p(this.getContext());
        this.setOnPlusOneClickListener(plusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener listener) {
        this.DE = listener;
        this.DB.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(listener));
    }

    public void setAnnotation(int annotation) {
        this.DC = annotation;
        this.p(this.getContext());
    }

    public void setSize(int size) {
        this.mSize = size;
        this.p(this.getContext());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View view = this.DB;
        this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.DB.layout(0, 0, right - left, bottom - top);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener DF;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener proxy) {
            this.DF = proxy;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.DB.getTag();
            if (this.DF != null) {
                this.DF.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.DD);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

