/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptionsCreator;
import com.google.android.gms.maps.model.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolylineOptions
implements SafeParcelable {
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    private final int kg;
    private final List<LatLng> CV;
    private float CB = 10.0f;
    private int mP = -16777216;
    private float Cw = 0.0f;
    private boolean Cx = true;
    private boolean CX = false;

    public PolylineOptions() {
        this.kg = 1;
        this.CV = new ArrayList<LatLng>();
    }

    PolylineOptions(int versionCode, List points, float width, int color2, float zIndex, boolean visible, boolean geodesic) {
        this.kg = versionCode;
        this.CV = points;
        this.CB = width;
        this.mP = color2;
        this.Cw = zIndex;
        this.Cx = visible;
        this.CX = geodesic;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eD()) {
            h.a(this, out, flags);
        } else {
            PolylineOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    int getVersionCode() {
        return this.kg;
    }

    public PolylineOptions add(LatLng point) {
        this.CV.add(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        this.CV.addAll(Arrays.asList(points));
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.CV.add(latLng);
        }
        return this;
    }

    public PolylineOptions width(float width) {
        this.CB = width;
        return this;
    }

    public PolylineOptions color(int color2) {
        this.mP = color2;
        return this;
    }

    public PolylineOptions zIndex(float zIndex) {
        this.Cw = zIndex;
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.Cx = visible;
        return this;
    }

    public PolylineOptions geodesic(boolean geodesic) {
        this.CX = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.CV;
    }

    public float getWidth() {
        return this.CB;
    }

    public int getColor() {
        return this.mP;
    }

    public float getZIndex() {
        return this.Cw;
    }

    public boolean isVisible() {
        return this.Cx;
    }

    public boolean isGeodesic() {
        return this.CX;
    }
}

