/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int kg;
    private final List<LatLng> CV;
    private final List<List<LatLng>> CW;
    private float Ct = 10.0f;
    private int Cu = -16777216;
    private int Cv = 0;
    private float Cw = 0.0f;
    private boolean Cx = true;
    private boolean CX = false;

    public PolygonOptions() {
        this.kg = 1;
        this.CV = new ArrayList<LatLng>();
        this.CW = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.kg = versionCode;
        this.CV = points;
        this.CW = holes;
        this.Ct = strokeWidth;
        this.Cu = strokeColor;
        this.Cv = fillColor;
        this.Cw = zIndex;
        this.Cx = visible;
        this.CX = geodesic;
    }

    int getVersionCode() {
        return this.kg;
    }

    List eH() {
        return this.CW;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eD()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.CV.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.CV.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.CV.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.CW.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.Ct = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.Cu = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.Cv = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.Cw = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.Cx = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.CX = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.CV;
    }

    public List<List<LatLng>> getHoles() {
        return this.CW;
    }

    public float getStrokeWidth() {
        return this.Ct;
    }

    public int getStrokeColor() {
        return this.Cu;
    }

    public int getFillColor() {
        return this.Cv;
    }

    public float getZIndex() {
        return this.Cw;
    }

    public boolean isVisible() {
        return this.Cx;
    }

    public boolean isGeodesic() {
        return this.CX;
    }
}

