/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLngCreator;
import com.google.android.gms.maps.model.e;

public final class LatLng
implements SafeParcelable {
    public static final LatLngCreator CREATOR = new LatLngCreator();
    private final int kg;
    public final double latitude;
    public final double longitude;

    LatLng(int versionCode, double latitude, double longitude) {
        this.kg = versionCode;
        this.longitude = -180.0 <= longitude && longitude < 180.0 ? longitude : ((longitude - 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        this.latitude = Math.max(-90.0, Math.min(90.0, latitude));
    }

    public LatLng(double latitude, double longitude) {
        this(1, latitude, longitude);
    }

    int getVersionCode() {
        return this.kg;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eD()) {
            e.a(this, out, flags);
        } else {
            LatLngCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits(this.latitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.longitude);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLng)) {
            return false;
        }
        LatLng latLng = (LatLng)o2;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(latLng.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(latLng.longitude);
    }

    public String toString() {
        return "lat/lng: (" + this.latitude + "," + this.longitude + ")";
    }
}

