/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.internal.eg;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int kg;
    private BitmapDescriptor Cz;
    private LatLng CA;
    private float CB;
    private float CC;
    private LatLngBounds CD;
    private float Cp;
    private float Cw;
    private boolean Cx = true;
    private float CE = 0.0f;
    private float CF = 0.5f;
    private float CG = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.kg = versionCode;
        this.Cz = new BitmapDescriptor(b.a.E(wrappedImage));
        this.CA = location;
        this.CB = width;
        this.CC = height;
        this.CD = bounds;
        this.Cp = bearing;
        this.Cw = zIndex;
        this.Cx = visible;
        this.CE = transparency;
        this.CF = anchorU;
        this.CG = anchorV;
    }

    public GroundOverlayOptions() {
        this.kg = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eD()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder eF() {
        return this.Cz.el().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.Cz = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.CF = u2;
        this.CG = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        eg.a(this.CD == null, "Position has already been set using positionFromBounds");
        eg.b(location != null, (Object)"Location must be specified");
        eg.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        eg.a(this.CD == null, "Position has already been set using positionFromBounds");
        eg.b(location != null, (Object)"Location must be specified");
        eg.b(width >= 0.0f, (Object)"Width must be non-negative");
        eg.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.CA = latLng;
        this.CB = f2;
        this.CC = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        eg.a(this.CA == null, "Position has already been set using position: " + this.CA);
        this.CD = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.Cp = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.Cw = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.Cx = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        eg.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.CE = transparency;
        return this;
    }

    int getVersionCode() {
        return this.kg;
    }

    public BitmapDescriptor getImage() {
        return this.Cz;
    }

    public LatLng getLocation() {
        return this.CA;
    }

    public float getWidth() {
        return this.CB;
    }

    public float getHeight() {
        return this.CC;
    }

    public LatLngBounds getBounds() {
        return this.CD;
    }

    public float getBearing() {
        return this.Cp;
    }

    public float getZIndex() {
        return this.Cw;
    }

    public float getTransparency() {
        return this.CE;
    }

    public float getAnchorU() {
        return this.CF;
    }

    public float getAnchorV() {
        return this.CG;
    }

    public boolean isVisible() {
        return this.Cx;
    }
}

