/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int kg;
    private Boolean BJ;
    private Boolean BK;
    private int BL = -1;
    private CameraPosition BM;
    private Boolean BN;
    private Boolean BO;
    private Boolean BP;
    private Boolean BQ;
    private Boolean BR;
    private Boolean BS;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.kg = versionCode;
        this.BJ = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.BK = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.BL = mapType;
        this.BM = camera;
        this.BN = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.BO = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.BP = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.BQ = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.BR = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.BS = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eD()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.kg;
    }

    byte eo() {
        return com.google.android.gms.maps.internal.a.c(this.BJ);
    }

    byte ep() {
        return com.google.android.gms.maps.internal.a.c(this.BK);
    }

    byte eq() {
        return com.google.android.gms.maps.internal.a.c(this.BN);
    }

    byte er() {
        return com.google.android.gms.maps.internal.a.c(this.BO);
    }

    byte es() {
        return com.google.android.gms.maps.internal.a.c(this.BP);
    }

    byte et() {
        return com.google.android.gms.maps.internal.a.c(this.BQ);
    }

    byte eu() {
        return com.google.android.gms.maps.internal.a.c(this.BR);
    }

    byte ev() {
        return com.google.android.gms.maps.internal.a.c(this.BS);
    }

    public GoogleMapOptions() {
        this.kg = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.BJ = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.BK = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.BL = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.BM = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.BN = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.BO = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.BP = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.BQ = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.BR = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.BS = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.BJ;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.BK;
    }

    public int getMapType() {
        return this.BL;
    }

    public CameraPosition getCamera() {
        return this.BM;
    }

    public Boolean getZoomControlsEnabled() {
        return this.BN;
    }

    public Boolean getCompassEnabled() {
        return this.BO;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.BP;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.BQ;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.BR;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.BS;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

