/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ee;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int kg;
    int mPriority;
    long xB;
    long xC;
    boolean xD;
    long xu;
    int xE;
    float xF;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.kg = 1;
        this.mPriority = 102;
        this.xB = 3600000L;
        this.xC = 600000L;
        this.xD = false;
        this.xu = Long.MAX_VALUE;
        this.xE = Integer.MAX_VALUE;
        this.xF = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.aO(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.m(millis);
        this.xB = millis;
        if (!this.xD) {
            this.xC = (long)((double)this.xB / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.xB;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.m(millis);
        this.xD = true;
        this.xC = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.xC;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.xu = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.xu < 0L) {
            this.xu = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.xu = millis;
        if (this.xu < 0L) {
            this.xu = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.xu;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.xE = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.xE;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.xF = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.xF;
    }

    private static void m(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void aO(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.kg = versionCode;
        this.mPriority = priority;
        this.xB = interval;
        this.xC = fastestInterval;
        this.xD = explicitFastestInterval;
        this.xu = expireAt;
        this.xE = numUpdates;
        this.xF = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String aP(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.aP(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.xB + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.xC + "ms");
        if (this.xu != Long.MAX_VALUE) {
            long l2 = this.xu - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.xE != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.xE);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return ee.hashCode(this.mPriority, this.xB, this.xC, this.xD, this.xu, this.xE, Float.valueOf(this.xF));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.xB == locationRequest.xB && this.xC == locationRequest.xC && this.xD == locationRequest.xD && this.xu == locationRequest.xu && this.xE == locationRequest.xE && this.xF == locationRequest.xF;
    }

    int getVersionCode() {
        return this.kg;
    }
}

