/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ViewSwitcher;
import com.google.android.gms.dynamic.b;
import com.google.android.gms.dynamic.c;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.ae;
import com.google.android.gms.internal.al;
import com.google.android.gms.internal.av;
import com.google.android.gms.internal.az;
import com.google.android.gms.internal.bb;
import com.google.android.gms.internal.bk;
import com.google.android.gms.internal.bm;
import com.google.android.gms.internal.bn;
import com.google.android.gms.internal.bq;
import com.google.android.gms.internal.bu;
import com.google.android.gms.internal.bz;
import com.google.android.gms.internal.cj;
import com.google.android.gms.internal.ck;
import com.google.android.gms.internal.cm;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cs;
import com.google.android.gms.internal.ct;
import com.google.android.gms.internal.cu;
import com.google.android.gms.internal.cw;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.g;
import com.google.android.gms.internal.h;
import com.google.android.gms.internal.q;
import com.google.android.gms.internal.s;
import com.google.android.gms.internal.v;
import com.google.android.gms.internal.x;

public final class r
extends ac.a
implements al,
av,
bn,
bq,
bu.a,
q {
    private final bb ed;
    private final a ee;
    private final s ef;

    public r(Context context, x x2, String string2, bb bb2, cu cu2) {
        this.ee = new a(context, x2, string2, cu2);
        this.ed = bb2;
        this.ef = new s(this);
        ct.t("Use AdRequest.Builder.addTestDevice(\"" + cs.l(context) + "\") to get test ads on this device.");
        co.i(context);
    }

    public void destroy() {
        eg.N("destroy must be called on the main UI thread.");
        this.ee.ek = null;
        this.ee.eo = null;
        this.ef.cancel();
        this.stopLoading();
        if (this.ee.eg != null) {
            this.ee.eg.removeAllViews();
        }
        if (this.ee.en != null && this.ee.en.gJ != null) {
            this.ee.en.gJ.destroy();
        }
    }

    public b x() {
        eg.N("getAdFrame must be called on the main UI thread.");
        return c.h(this.ee.eg);
    }

    public x y() {
        eg.N("getAdSize must be called on the main UI thread.");
        return this.ee.em;
    }

    public boolean isReady() {
        eg.N("isLoaded must be called on the main UI thread.");
        return this.ee.el == null && this.ee.en != null;
    }

    public boolean a(v v2) {
        cw cw2;
        eg.N("loadAd must be called on the main UI thread.");
        if (this.ee.el != null) {
            ct.v("An ad request is already in progress. Aborting.");
            return false;
        }
        if (this.ee.em.eG && this.ee.en != null) {
            ct.v("An interstitial is already loading. Aborting.");
            return false;
        }
        if (!this.M()) {
            return false;
        }
        ct.t("Starting ad request.");
        this.ef.cancel();
        bz.a a2 = this.c(v2);
        if (this.ee.em.eG) {
            cw2 = cw.a(this.ee.eh, this.ee.em, false, false, this.ee.ei, this.ee.ej);
            cw2.aC().a(this, null, this, this, true);
        } else {
            View view = this.ee.eg.getNextView();
            if (view instanceof cw) {
                cw2 = (cw)view;
                cw2.a(this.ee.eh, this.ee.em);
            } else {
                if (view != null) {
                    this.ee.eg.removeView(view);
                }
                cw2 = cw.a(this.ee.eh, this.ee.em, false, false, this.ee.ei, this.ee.ej);
                if (this.ee.em.eH == null) {
                    this.b((View)cw2);
                }
            }
            cw2.aC().a(this, this, this, this, false);
        }
        this.ee.el = bu.a(this.ee.eh, a2, this.ee.ei, cw2, this.ed, this);
        return true;
    }

    public void a(cj cj2) {
        boolean bl2;
        this.ee.el = null;
        if (cj2.errorCode == -1) {
            return;
        }
        boolean bl3 = bl2 = cj2.hr.extras != null ? cj2.hr.extras.getBoolean("_noRefresh", false) : false;
        if (this.ee.em.eG) {
            co.a(cj2.gJ);
        } else if (!bl2) {
            if (cj2.fO > 0L) {
                this.ef.a(cj2.hr, cj2.fO);
            } else if (cj2.is != null && cj2.is.fO > 0L) {
                this.ef.a(cj2.hr, cj2.is.fO);
            } else if (!cj2.hy && cj2.errorCode == 2) {
                this.ef.d(cj2.hr);
            }
        }
        if (cj2.errorCode == 3 && cj2.is != null && cj2.is.fM != null) {
            ct.r("Pinging no fill URLs.");
            az.a(this.ee.eh, this.ee.ej.iJ, cj2, this.ee.adUnitId, false, cj2.is.fM);
        }
        if (cj2.errorCode != -2) {
            this.a(cj2.errorCode);
            return;
        }
        if (!this.ee.em.eG && !this.b(cj2)) {
            this.a(0);
            return;
        }
        if (this.ee.en != null && this.ee.en.ge != null) {
            this.ee.en.ge.a((av)null);
        }
        if (cj2.ge != null) {
            cj2.ge.a(this);
        }
        this.ee.en = cj2;
        if (cj2.it != null) {
            this.ee.em = cj2.it;
        }
        if (!this.ee.em.eG) {
            this.b(false);
        }
        this.L();
    }

    public void w() {
        this.N();
    }

    public void z() {
        this.J();
    }

    public void A() {
        if (this.ee.em.eG) {
            this.O();
        }
        this.I();
    }

    public void B() {
        if (this.ee.em.eG) {
            this.b(false);
        }
        this.K();
    }

    public void onAppEvent(String name, String info) {
        if (this.ee.eo != null) {
            try {
                this.ee.eo.onAppEvent(name, info);
            }
            catch (RemoteException remoteException) {
                ct.b("Could not call the AppEventListener.", remoteException);
            }
        }
    }

    public void C() {
        this.w();
    }

    public void D() {
        this.A();
    }

    public void E() {
        this.z();
    }

    public void F() {
        this.B();
    }

    public void G() {
        if (this.ee.en != null) {
            ct.v("Mediation adapter " + this.ee.en.gd + " refreshed, but mediation adapters should never refresh.");
        }
        this.b(true);
        this.L();
    }

    public void pause() {
        eg.N("pause must be called on the main UI thread.");
        if (this.ee.en != null) {
            co.a(this.ee.en.gJ);
        }
    }

    public void H() {
        eg.N("recordManualImpression must be called on the main UI thread.");
        if (this.ee.en == null) {
            ct.v("Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        ct.r("Pinging manual tracking URLs.");
        if (this.ee.en.hA != null) {
            co.a(this.ee.eh, this.ee.ej.iJ, this.ee.en.hA);
        }
    }

    public void resume() {
        eg.N("resume must be called on the main UI thread.");
        if (this.ee.en != null) {
            co.b(this.ee.en.gJ);
        }
    }

    public void b(v v2) {
        ViewParent viewParent = this.ee.eg.getParent();
        if (viewParent instanceof View && ((View)viewParent).isShown() && co.at()) {
            this.a(v2);
        } else {
            ct.t("Ad is not visible. Not refreshing ad.");
            this.ef.d(v2);
        }
    }

    public void a(ab ab2) {
        eg.N("setAdListener must be called on the main UI thread.");
        this.ee.ek = ab2;
    }

    public void a(x x2) {
        eg.N("setAdSize must be called on the main UI thread.");
        this.ee.em = x2;
        if (this.ee.en != null) {
            this.ee.en.gJ.a(x2);
        }
        if (this.ee.eg.getChildCount() > 1) {
            this.ee.eg.removeView(this.ee.eg.getNextView());
        }
        this.ee.eg.setMinimumWidth(x2.widthPixels);
        this.ee.eg.setMinimumHeight(x2.heightPixels);
        this.ee.eg.requestLayout();
    }

    public void a(ae ae2) {
        eg.N("setAppEventListener must be called on the main UI thread.");
        this.ee.eo = ae2;
    }

    public void showInterstitial() {
        eg.N("showInterstitial must be called on the main UI thread.");
        if (!this.ee.em.eG) {
            ct.v("Cannot call showInterstitial on a banner ad.");
            return;
        }
        if (this.ee.en == null) {
            ct.v("The interstitial has not loaded.");
            return;
        }
        if (this.ee.en.gJ.aF()) {
            ct.v("The interstitial is already showing.");
            return;
        }
        this.ee.en.gJ.l(true);
        if (this.ee.en.hy) {
            try {
                this.ee.en.gc.showInterstitial();
            }
            catch (RemoteException remoteException) {
                ct.b("Could not show interstitial.", remoteException);
                this.O();
            }
        } else {
            bm bm2 = new bm(this, this, this, this.ee.en.gJ, this.ee.en.orientation, this.ee.ej);
            bk.a(this.ee.eh, bm2);
        }
    }

    public void stopLoading() {
        eg.N("stopLoading must be called on the main UI thread.");
        if (this.ee.en != null) {
            this.ee.en.gJ.stopLoading();
            this.ee.en = null;
        }
        if (this.ee.el != null) {
            this.ee.el.cancel();
        }
    }

    private void b(View view) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        this.ee.eg.addView(view, layoutParams);
    }

    private void I() {
        ct.t("Ad closing.");
        if (this.ee.ek != null) {
            try {
                this.ee.ek.onAdClosed();
            }
            catch (RemoteException remoteException) {
                ct.b("Could not call AdListener.onAdClosed().", remoteException);
            }
        }
    }

    private void a(int n2) {
        ct.v("Failed to load ad: " + n2);
        if (this.ee.ek != null) {
            try {
                this.ee.ek.onAdFailedToLoad(n2);
            }
            catch (RemoteException remoteException) {
                ct.b("Could not call AdListener.onAdFailedToLoad().", remoteException);
            }
        }
    }

    private void J() {
        ct.t("Ad leaving application.");
        if (this.ee.ek != null) {
            try {
                this.ee.ek.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                ct.b("Could not call AdListener.onAdLeftApplication().", remoteException);
            }
        }
    }

    private void K() {
        ct.t("Ad opening.");
        if (this.ee.ek != null) {
            try {
                this.ee.ek.onAdOpened();
            }
            catch (RemoteException remoteException) {
                ct.b("Could not call AdListener.onAdOpened().", remoteException);
            }
        }
    }

    private void L() {
        ct.t("Ad finished loading.");
        if (this.ee.ek != null) {
            try {
                this.ee.ek.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                ct.b("Could not call AdListener.onAdLoaded().", remoteException);
            }
        }
    }

    private boolean M() {
        boolean bl2 = true;
        if (!co.a(this.ee.eh.getPackageManager(), this.ee.eh.getPackageName(), "android.permission.INTERNET")) {
            if (!this.ee.em.eG) {
                cs.a((ViewGroup)this.ee.eg, this.ee.em, "Missing internet permission in AndroidManifest.xml.", "Missing internet permission in AndroidManifest.xml. You must have the following declaration: <uses-permission android:name=\"android.permission.INTERNET\" />");
            }
            bl2 = false;
        }
        if (!co.h(this.ee.eh)) {
            if (!this.ee.em.eG) {
                cs.a((ViewGroup)this.ee.eg, this.ee.em, "Missing AdActivity with android:configChanges in AndroidManifest.xml.", "Missing AdActivity with android:configChanges in AndroidManifest.xml. You must have the following declaration within the <application> element: <activity android:name=\"com.google.android.gms.ads.AdActivity\" android:configChanges=\"keyboard|keyboardHidden|orientation|screenLayout|uiMode|screenSize|smallestScreenSize\" />");
            }
            bl2 = false;
        }
        if (!bl2 && !this.ee.em.eG) {
            this.ee.eg.setVisibility(0);
        }
        return bl2;
    }

    private bz.a c(v v2) {
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.ee.eh.getApplicationInfo();
        try {
            packageManager = this.ee.eh.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = null;
        if (!this.ee.em.eG && this.ee.eg.getParent() != null) {
            int[] nArray = new int[2];
            this.ee.eg.getLocationOnScreen(nArray);
            int n2 = nArray[0];
            int n3 = nArray[1];
            DisplayMetrics displayMetrics = this.ee.eh.getResources().getDisplayMetrics();
            int n4 = this.ee.eg.getWidth();
            int n5 = this.ee.eg.getHeight();
            int n6 = 0;
            if (this.ee.eg.isShown() && n2 + n4 > 0 && n3 + n5 > 0 && n2 <= displayMetrics.widthPixels && n3 <= displayMetrics.heightPixels) {
                n6 = 1;
            }
            packageManager = new Bundle(5);
            packageManager.putInt("x", n2);
            packageManager.putInt("y", n3);
            packageManager.putInt("width", n4);
            packageManager.putInt("height", n5);
            packageManager.putInt("visible", n6);
        }
        return new bz.a((Bundle)packageManager, v2, this.ee.em, this.ee.adUnitId, applicationInfo, packageInfo, ck.ar(), ck.iu, this.ee.ej);
    }

    private void N() {
        if (this.ee.en == null) {
            ct.v("Ad state was null when trying to ping click URLs.");
            return;
        }
        ct.r("Pinging click URLs.");
        if (this.ee.en.fK != null) {
            co.a(this.ee.eh, this.ee.ej.iJ, this.ee.en.fK);
        }
        if (this.ee.en.is != null && this.ee.en.is.fK != null) {
            az.a(this.ee.eh, this.ee.ej.iJ, this.ee.en, this.ee.adUnitId, false, this.ee.en.is.fK);
        }
    }

    private void b(boolean bl2) {
        if (this.ee.en == null) {
            ct.v("Ad state was null when trying to ping impression URLs.");
            return;
        }
        ct.r("Pinging Impression URLs.");
        if (this.ee.en.fL != null) {
            co.a(this.ee.eh, this.ee.ej.iJ, this.ee.en.fL);
        }
        if (this.ee.en.is != null && this.ee.en.is.fL != null) {
            az.a(this.ee.eh, this.ee.ej.iJ, this.ee.en, this.ee.adUnitId, bl2, this.ee.en.is.fL);
        }
        if (this.ee.en.gb != null && this.ee.en.gb.fG != null) {
            az.a(this.ee.eh, this.ee.ej.iJ, this.ee.en, this.ee.adUnitId, bl2, this.ee.en.gb.fG);
        }
    }

    private void O() {
        if (this.ee.en != null) {
            this.ee.en.gJ.destroy();
            this.ee.en = null;
        }
    }

    private boolean b(cj cj2) {
        View view;
        if (cj2.hy) {
            try {
                view = (View)c.b(cj2.gc.getView());
            }
            catch (RemoteException remoteException) {
                ct.b("Could not get View from mediation adapter.", remoteException);
                return false;
            }
            View view2 = this.ee.eg.getNextView();
            if (view2 != null) {
                this.ee.eg.removeView(view2);
            }
            try {
                this.b(view);
            }
            catch (Throwable throwable) {
                ct.b("Could not add mediation view to view hierarchy.", throwable);
                return false;
            }
        }
        if (cj2.it != null) {
            cj2.gJ.a(cj2.it);
            this.ee.eg.removeAllViews();
            this.ee.eg.setMinimumWidth(cj2.it.widthPixels);
            this.ee.eg.setMinimumHeight(cj2.it.heightPixels);
            this.b((View)cj2.gJ);
        }
        if (this.ee.eg.getChildCount() > 1) {
            this.ee.eg.showNext();
        }
        if (this.ee.en != null) {
            view = this.ee.eg.getNextView();
            if (view instanceof cw) {
                ((cw)view).a(this.ee.eh, this.ee.em);
            } else if (view != null) {
                this.ee.eg.removeView(view);
            }
            if (this.ee.en.gc != null) {
                try {
                    this.ee.en.gc.destroy();
                }
                catch (RemoteException remoteException) {
                    ct.v("Could not destroy previous mediation adapter.");
                }
            }
        }
        this.ee.eg.setVisibility(0);
        return true;
    }

    private static final class a {
        public final ViewSwitcher eg;
        public final String adUnitId;
        public final Context eh;
        public final h ei;
        public final cu ej;
        public ab ek;
        public cm el;
        public x em;
        public cj en;
        public ae eo;

        public a(Context context, x x2, String string2, cu cu2) {
            if (x2.eG) {
                this.eg = null;
            } else {
                this.eg = new ViewSwitcher(context);
                this.eg.setMinimumWidth(x2.widthPixels);
                this.eg.setMinimumHeight(x2.heightPixels);
                this.eg.setVisibility(4);
            }
            this.em = x2;
            this.adUnitId = string2;
            this.eh = context;
            this.ei = new h(g.a(cu2.iJ, context));
            this.ej = cu2;
        }
    }
}

