/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.dw;
import com.google.android.gms.internal.ec;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.gk;
import com.google.android.gms.internal.gl;
import com.google.android.gms.internal.gm;
import com.google.android.gms.internal.go;
import com.google.android.gms.internal.gq;
import com.google.android.gms.location.LocationClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationStatusCodes;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class gn
extends dw<gl> {
    private final gq<gl> xP = new c();
    private final gm xV;
    private final HashMap xW = new HashMap();
    private final String xX;
    private final String jG;

    public gn(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        super(context, connectionCallbacks, onConnectionFailedListener, new String[0]);
        this.xV = new gm(context, this.xP);
        this.xX = string;
        this.jG = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        gm gm2 = this.xV;
        synchronized (gm2) {
            if (this.isConnected()) {
                this.xV.removeAllListeners();
                this.xV.dI();
            }
            super.disconnect();
        }
    }

    @Override
    protected String am() {
        return "com.google.android.location.internal.GoogleLocationManagerService.START";
    }

    @Override
    protected String an() {
        return "com.google.android.gms.location.internal.IGoogleLocationManagerService";
    }

    public void requestActivityUpdates(long detectionIntervalMillis, PendingIntent callbackIntent) {
        this.bP();
        eg.f(callbackIntent);
        eg.b(detectionIntervalMillis >= 0L, (Object)"detectionIntervalMillis must be >= 0");
        try {
            ((gl)this.bQ()).a(detectionIntervalMillis, true, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeActivityUpdates(PendingIntent callbackIntent) {
        this.bP();
        eg.f(callbackIntent);
        try {
            ((gl)this.bQ()).removeActivityUpdates(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void addGeofences(List<go> geofences, PendingIntent pendingIntent, LocationClient.OnAddGeofencesResultListener listener) {
        this.bP();
        eg.b(geofences != null && geofences.size() > 0, (Object)"At least one geofence must be specified.");
        eg.b(pendingIntent, (Object)"PendingIntent must be specified.");
        eg.b(listener, (Object)"OnAddGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((gl)this.bQ()).a(geofences, pendingIntent, b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(PendingIntent pendingIntent, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bP();
        eg.b(pendingIntent, (Object)"PendingIntent must be specified.");
        eg.b(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((gl)this.bQ()).a(pendingIntent, (gk)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void removeGeofences(List<String> geofenceRequestIds, LocationClient.OnRemoveGeofencesResultListener listener) {
        this.bP();
        eg.b(geofenceRequestIds != null && geofenceRequestIds.size() > 0, (Object)"geofenceRequestIds can't be null nor empty.");
        eg.b(listener, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = geofenceRequestIds.toArray(new String[0]);
        try {
            b b2 = listener == null ? null : new b(listener, this);
            ((gl)this.bQ()).a(stringArray, (gk)b2, this.getContext().getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public Location getLastLocation() {
        return this.xV.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.requestLocationUpdates(request, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        gm gm2 = this.xV;
        synchronized (gm2) {
            this.xV.requestLocationUpdates(request, listener, looper);
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.xV.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.xV.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.xV.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.xV.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.xV.setMockLocation(mockLocation);
    }

    protected gl M(IBinder iBinder) {
        return gl.a.L(iBinder);
    }

    @Override
    protected void a(ec ec2, dw.e e2) throws RemoteException {
        Bundle bundle = new Bundle();
        bundle.putString("client_name", this.xX);
        ec2.e(e2, 4242000, this.getContext().getPackageName(), bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.M(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class d
    extends dw.b<LocationClient.OnRemoveGeofencesResultListener> {
        private final int mC;
        private final String[] xY;
        private final PendingIntent mPendingIntent;
        private final int yd;

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, String[] stringArray) {
            super(gn.this, onRemoveGeofencesResultListener);
            ds.p(n2 == 2);
            this.yd = n2;
            this.mC = LocationStatusCodes.aR(n3);
            this.xY = stringArray;
            this.mPendingIntent = null;
        }

        public d(int n2, LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, int n3, PendingIntent pendingIntent) {
            super(gn.this, onRemoveGeofencesResultListener);
            ds.p(n2 == 1);
            this.yd = n2;
            this.mC = LocationStatusCodes.aR(n3);
            this.mPendingIntent = pendingIntent;
            this.xY = null;
        }

        protected void a(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener) {
            if (onRemoveGeofencesResultListener != null) {
                switch (this.yd) {
                    case 1: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByPendingIntentResult(this.mC, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        onRemoveGeofencesResultListener.onRemoveGeofencesByRequestIdsResult(this.mC, this.xY);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.yd));
                    }
                }
            }
        }

        @Override
        protected void aL() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((LocationClient.OnRemoveGeofencesResultListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class a
    extends dw.b<LocationClient.OnAddGeofencesResultListener> {
        private final int mC;
        private final String[] xY;

        public a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, int n2, String[] stringArray) {
            super(gn.this, onAddGeofencesResultListener);
            this.mC = LocationStatusCodes.aR(n2);
            this.xY = stringArray;
        }

        protected void a(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener) {
            if (onAddGeofencesResultListener != null) {
                onAddGeofencesResultListener.onAddGeofencesResult(this.mC, this.xY);
            }
        }

        @Override
        protected void aL() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((LocationClient.OnAddGeofencesResultListener)object);
        }
    }

    private static final class b
    extends gk.a {
        private LocationClient.OnAddGeofencesResultListener ya;
        private LocationClient.OnRemoveGeofencesResultListener yb;
        private gn yc;

        public b(LocationClient.OnAddGeofencesResultListener onAddGeofencesResultListener, gn gn2) {
            this.ya = onAddGeofencesResultListener;
            this.yb = null;
            this.yc = gn2;
        }

        public b(LocationClient.OnRemoveGeofencesResultListener onRemoveGeofencesResultListener, gn gn2) {
            this.yb = onRemoveGeofencesResultListener;
            this.ya = null;
            this.yc = gn2;
        }

        public void onAddGeofencesResult(int statusCode, String[] geofenceRequestIds) throws RemoteException {
            if (this.yc == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            gn gn2 = this.yc;
            gn2.getClass();
            this.yc.a(gn2.new a(this.ya, statusCode, geofenceRequestIds));
            this.yc = null;
            this.ya = null;
            this.yb = null;
        }

        public void onRemoveGeofencesByRequestIdsResult(int statusCode, String[] geofenceRequestIds) {
            if (this.yc == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByRequestIdsResult called multiple times");
                return;
            }
            gn gn2 = this.yc;
            gn2.getClass();
            this.yc.a(gn2.new d(2, this.yb, statusCode, geofenceRequestIds));
            this.yc = null;
            this.ya = null;
            this.yb = null;
        }

        public void onRemoveGeofencesByPendingIntentResult(int statusCode, PendingIntent pendingIntent) {
            if (this.yc == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByPendingIntentResult called multiple times");
                return;
            }
            gn gn2 = this.yc;
            gn2.getClass();
            this.yc.a(gn2.new d(1, this.yb, statusCode, pendingIntent));
            this.yc = null;
            this.ya = null;
            this.yb = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class c
    implements gq<gl> {
        private c() {
        }

        @Override
        public void bP() {
            gn.this.bP();
        }

        public gl dJ() {
            return (gl)gn.this.bQ();
        }

        @Override
        public /* synthetic */ IInterface bQ() {
            return this.dJ();
        }
    }
}

