/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.gl;
import com.google.android.gms.internal.gq;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.c;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class gm {
    private final gq<gl> xP;
    private final Context mContext;
    private ContentProviderClient xQ = null;
    private boolean xR = false;
    private HashMap<LocationListener, b> xS = new HashMap();

    public gm(Context context, gq<gl> gq2) {
        this.mContext = context;
        this.xP = gq2;
    }

    public Location getLastLocation() {
        this.xP.bP();
        try {
            return this.xP.bQ().an(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.xP.bP();
        if (looper == null) {
            eg.b(Looper.myLooper(), (Object)"Can't create handler inside thread that has not called Looper.prepare()");
        }
        HashMap<LocationListener, b> hashMap = this.xS;
        synchronized (hashMap) {
            b b2 = this.xS.get(listener);
            if (b2 == null) {
                b2 = new b(listener, looper);
            }
            this.xS.put(listener, b2);
            try {
                this.xP.bQ().a(request, b2, this.mContext.getPackageName());
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.xP.bP();
        try {
            this.xP.bQ().a(request, callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocationUpdates(LocationListener listener) {
        this.xP.bP();
        eg.b(listener, (Object)"Invalid null listener");
        HashMap<LocationListener, b> hashMap = this.xS;
        synchronized (hashMap) {
            b b2 = this.xS.remove(listener);
            if (this.xQ != null && this.xS.isEmpty()) {
                this.xQ.release();
                this.xQ = null;
            }
            if (b2 != null) {
                b2.release();
                try {
                    this.xP.bQ().a(b2);
                }
                catch (RemoteException remoteException) {
                    throw new IllegalStateException(remoteException);
                }
            }
        }
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.xP.bP();
        try {
            this.xP.bQ().a(callbackIntent);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void setMockMode(boolean isMockMode) {
        this.xP.bP();
        try {
            this.xP.bQ().setMockMode(isMockMode);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
        this.xR = isMockMode;
    }

    public void setMockLocation(Location mockLocation) {
        this.xP.bP();
        try {
            this.xP.bQ().setMockLocation(mockLocation);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            HashMap<LocationListener, b> hashMap = this.xS;
            synchronized (hashMap) {
                for (b b2 : this.xS.values()) {
                    if (b2 == null) continue;
                    this.xP.bQ().a(b2);
                }
                this.xS.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void dI() {
        if (this.xR) {
            this.setMockMode(false);
        }
    }

    private static class a
    extends Handler {
        private final LocationListener xT;

        public a(LocationListener locationListener) {
            this.xT = locationListener;
        }

        public a(LocationListener locationListener, Looper looper) {
            super(looper);
            this.xT = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.xT.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class b
    extends c.a {
        private Handler xU;

        b(LocationListener locationListener, Looper looper) {
            this.xU = looper == null ? new a(locationListener) : new a(locationListener, looper);
        }

        public void onLocationChanged(Location location) {
            if (this.xU == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.xU.sendMessage(message);
        }

        public void release() {
            this.xU = null;
        }
    }
}

