/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.internal.dw;
import com.google.android.gms.internal.ec;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.fk;
import com.google.android.gms.internal.fn;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.fp;
import com.google.android.gms.internal.fq;
import com.google.android.gms.internal.fr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class fl
extends dw<fp>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private final String tO;
    private final String jG;
    private final Map<String, RealTimeSocket> tP;
    private PlayerEntity tQ;
    private GameEntity tR;
    private final fq tS;
    private boolean tT = false;
    private boolean tA = false;
    private int tB;
    private final Binder tU;
    private final long tV;
    private final boolean tW;
    private final int tX;

    @Deprecated
    public fl(Context context, String string, String string2, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2, boolean bl3, int n3) {
        this(context, string, string2, new dw.c(connectionCallbacks), new dw.g(onConnectionFailedListener), stringArray, n2, view, bl2, bl3, n3, 4368);
    }

    public fl(Context context, String string, String string2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2, boolean bl3, int n3, int n4) {
        super(context, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.tO = string;
        this.jG = eg.f(string2);
        this.tU = new Binder();
        this.tP = new HashMap<String, RealTimeSocket>();
        this.tS = fq.a(this, n2);
        this.setViewForPopups(view);
        this.tA = bl3;
        this.tB = n3;
        this.tV = this.hashCode();
        this.tW = bl2;
        this.tX = n4;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.tT) {
            this.tS.dl();
            this.tT = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.tT = false;
    }

    public void setGravityForPopups(int gravity) {
        this.tS.setGravity(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        this.tS.e(gamesContentView);
    }

    @Override
    protected void a(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (string.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            eg.a(!bl2, String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            eg.a(bl2, String.format("Games APIs requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.dc();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.tT = false;
        if (this.isConnected()) {
            try {
                fp fp2 = (fp)this.bQ();
                fp2.df();
                fp2.j(this.tV);
            }
            catch (RemoteException remoteException) {
                fn.c("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.de();
        super.disconnect();
    }

    @Override
    protected String am() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String an() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected fp F(IBinder iBinder) {
        return fp.a.H(iBinder);
    }

    @Override
    public Bundle aU() {
        try {
            Bundle bundle = ((fp)this.bQ()).aU();
            if (bundle != null) {
                bundle.setClassLoader(fl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return null;
        }
    }

    private void dc() {
        this.tQ = null;
    }

    @Override
    protected void a(ec ec2, dw.e e2) throws RemoteException {
        String string = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.tW);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.tA);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.tB);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.tX);
        ec2.a(e2, 4242000, this.getContext().getPackageName(), this.jG, this.bO(), this.tO, this.tS.dn(), string, bundle);
    }

    public String getCurrentAccountName() {
        try {
            return ((fp)this.bQ()).getCurrentAccountName();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return null;
        }
    }

    public String getCurrentPlayerId() {
        try {
            return ((fp)this.bQ()).getCurrentPlayerId();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getCurrentPlayer() {
        this.bP();
        fl fl2 = this;
        synchronized (fl2) {
            if (this.tQ == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((fp)this.bQ()).dg());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.tQ = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        playerBuffer.close();
                        throw throwable;
                    }
                    playerBuffer.close();
                    {
                    }
                }
                catch (RemoteException remoteException) {
                    fn.c("GamesClientImpl", "service died");
                }
            }
        }
        return this.tQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game getCurrentGame() {
        this.bP();
        fl fl2 = this;
        synchronized (fl2) {
            if (this.tR == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((fp)this.bQ()).di());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.tR = (GameEntity)gameBuffer.get(0).freeze();
                        }
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        gameBuffer.close();
                        throw throwable;
                    }
                    gameBuffer.close();
                    {
                    }
                }
                catch (RemoteException remoteException) {
                    fn.c("GamesClientImpl", "service died");
                }
            }
        }
        return this.tR;
    }

    public void a(a.c<Players.LoadPlayersResult> c2, String string) {
        try {
            ((fp)this.bQ()).c((fo)new ak(c2), string);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Players.LoadPlayersResult> c2, int n2, boolean bl2, boolean bl3) {
        try {
            ((fp)this.bQ()).a((fo)new ak(c2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Players.LoadPlayersResult> c2, String string, int n2, boolean bl2, boolean bl3) {
        if (!string.equals("playedWith")) {
            throw new IllegalArgumentException("Invalid player collection: " + string);
        }
        try {
            ((fp)this.bQ()).d(new ak(c2), string, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public Intent getAllLeaderboardsIntent() {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getAllLeaderboardsIntent();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getLeaderboardIntent(leaderboardId);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(a.c<Leaderboards.LeaderboardMetadataResult> c2, boolean bl2) {
        try {
            ((fp)this.bQ()).b((fo)new t(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LeaderboardMetadataResult> c2, String string, boolean bl2) {
        try {
            ((fp)this.bQ()).c((fo)new t(c2), string, bl2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LoadPlayerScoreResult> c2, String string, String string2, int n2, int n3) {
        try {
            ((fp)this.bQ()).a((fo)new ai(c2), string, string2, n2, n3);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LoadScoresResult> c2, String string, int n2, int n3, int n4, boolean bl2) {
        try {
            ((fp)this.bQ()).a((fo)new r(c2), string, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Leaderboards.LoadScoresResult> c2, String string, int n2, int n3, int n4, boolean bl2) {
        try {
            ((fp)this.bQ()).b(new r(c2), string, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.LoadScoresResult> c2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((fp)this.bQ()).a((fo)new r(c2), leaderboardScoreBuffer.dq().dr(), n2, n3);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Leaderboards.SubmitScoreResult> c2, String string, long l2, String string2) {
        try {
            aw aw2 = c2 == null ? null : new aw(c2);
            ((fp)this.bQ()).a((fo)aw2, string, l2, string2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public Intent getAchievementsIntent() {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getAchievementsIntent();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(a.c<Achievements.LoadAchievementsResult> c2, boolean bl2) {
        try {
            ((fp)this.bQ()).a((fo)new f(c2), bl2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Achievements.UpdateAchievementResult> c2, String string) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fp)this.bQ()).a((fo)d2, string, this.tS.dn(), this.tS.dm());
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void c(a.c<Achievements.UpdateAchievementResult> c2, String string) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fp)this.bQ()).b((fo)d2, string, this.tS.dn(), this.tS.dm());
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<Achievements.UpdateAchievementResult> c2, String string, int n2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fp)this.bQ()).a((fo)d2, string, n2, this.tS.dn(), this.tS.dm());
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Achievements.UpdateAchievementResult> c2, String string, int n2) {
        try {
            d d2 = c2 == null ? null : new d(c2);
            ((fp)this.bQ()).b((fo)d2, string, n2, this.tS.dn(), this.tS.dm());
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public Intent getMatchInboxIntent() {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getMatchInboxIntent();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent getInvitationInboxIntent() {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getInvitationInboxIntent();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        try {
            l l2 = new l(listener);
            ((fp)this.bQ()).a((fo)l2, this.tV);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void unregisterInvitationListener() {
        try {
            ((fp)this.bQ()).k(this.tV);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void registerMatchUpdateListener(OnTurnBasedMatchUpdateReceivedListener listener) {
        try {
            x x2 = new x(listener);
            ((fp)this.bQ()).b((fo)x2, this.tV);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void unregisterMatchUpdateListener() {
        try {
            ((fp)this.bQ()).l(this.tV);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public Intent getPlayerSearchIntent() {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getPlayerSearchIntent();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).a((RoomEntity)room.freeze(), minParticipantsToStart);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent getSettingsIntent() {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getSettingsIntent();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void g(a.c<GamesMetadata.LoadGamesResult> c2) {
        try {
            ((fp)this.bQ()).d(new j(c2));
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void b(a.c<Status> c2) {
        try {
            ((fp)this.bQ()).a(new au(c2));
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public int dd() {
        int n2 = 4368;
        try {
            n2 = ((fp)this.bQ()).dd();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String getAppId() {
        try {
            return ((fp)this.bQ()).getAppId();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return null;
        }
    }

    public void h(a.c<Invitations.LoadInvitationsResult> c2) {
        try {
            ((fp)this.bQ()).e(new o(c2));
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void i(String string, int n2) {
        try {
            ((fp)this.bQ()).i(string, n2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void j(String string, int n2) {
        try {
            ((fp)this.bQ()).j(string, n2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public Intent getTurnBasedSelectOpponentsIntent(int minPlayers, int maxPlayers, boolean allowAutomatch) {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getTurnBasedSelectOpponentsIntent(minPlayers, maxPlayers, allowAutomatch);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((fp)this.bQ()).a((fo)new bb(c2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.getMinPlayers(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void d(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, String string) {
        try {
            ((fp)this.bQ()).n(new bb(c2), string);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void e(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, String string) {
        try {
            ((fp)this.bQ()).o(new bb(c2), string);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public int getMaxTurnBasedMatchDataSize() {
        int n2 = 2;
        try {
            n2 = ((fp)this.bQ()).getMaxTurnBasedMatchDataSize();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2, String string, byte[] byArray, String string2, ParticipantResult[] participantResultArray) {
        try {
            ((fp)this.bQ()).a((fo)new bh(c2), string, byArray, string2, participantResultArray);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2, String string, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((fp)this.bQ()).a((fo)new bh(c2), string, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void f(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2, String string) {
        try {
            ((fp)this.bQ()).q(new bd(c2), string);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2, String string, String string2) {
        try {
            ((fp)this.bQ()).d((fo)new bd(c2), string, string2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void g(a.c<TurnBasedMultiplayer.CancelMatchResult> c2, String string) {
        try {
            ((fp)this.bQ()).p(new az(c2), string);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void dismissTurnBasedMatch(String matchId) {
        try {
            ((fp)this.bQ()).ak(matchId);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void a(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2, int[] nArray) {
        try {
            ((fp)this.bQ()).a((fo)new bj(c2), nArray);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void h(a.c<TurnBasedMultiplayer.LoadMatchResult> c2, String string) {
        try {
            ((fp)this.bQ()).r(new bf(c2), string);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public Intent getRealTimeSelectOpponentsIntent(int minPlayers, int maxPlayers, boolean allowAutomatch) {
        Intent intent;
        try {
            intent = ((fp)this.bQ()).getRealTimeSelectOpponentsIntent(minPlayers, maxPlayers, allowAutomatch);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void createRoom(RoomConfig config) {
        try {
            aq aq2 = new aq(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((fp)this.bQ()).a((fo)aq2, (IBinder)this.tU, config.getVariant(), config.getInvitedPlayerIds(), config.getAutoMatchCriteria(), config.isSocketEnabled(), this.tV);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void joinRoom(RoomConfig config) {
        try {
            aq aq2 = new aq(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((fp)this.bQ()).a((fo)aq2, (IBinder)this.tU, config.getInvitationId(), config.isSocketEnabled(), this.tV);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        try {
            ((fp)this.bQ()).e(new aq(listener), roomId);
            this.de();
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string, String string2) {
        try {
            return ((fp)this.bQ()).a((fo)new an(reliableMessageSentCallback), byArray, string, string2);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string, String[] stringArray) {
        eg.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((fp)this.bQ()).b(byArray, string, stringArray);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        try {
            return ((fp)this.bQ()).b(messageData, roomId, null);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        if (participantId == null || !ParticipantUtils.am(participantId)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.tP.get(participantId);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.ae(participantId);
        }
        return realTimeSocket;
    }

    private RealTimeSocket ae(String string) {
        try {
            String string2 = ((fp)this.bQ()).ag(string);
            if (string2 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string2));
            }
            catch (IOException iOException) {
                fn.d("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            fr fr2 = new fr(localSocket, string);
            this.tP.put(string, fr2);
            return fr2;
        }
        catch (RemoteException remoteException) {
            fn.d("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void clearNotifications(int notificationTypes) {
        try {
            ((fp)this.bQ()).clearNotifications(notificationTypes);
        }
        catch (RemoteException remoteException) {
            fn.c("GamesClientImpl", "service died");
        }
    }

    private void de() {
        for (RealTimeSocket realTimeSocket : this.tP.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                fn.a("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.tP.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((fp)this.bQ()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                fn.c("GamesClientImpl", "service died");
            }
        }
    }

    public void df() {
        if (this.isConnected()) {
            try {
                ((fp)this.bQ()).df();
            }
            catch (RemoteException remoteException) {
                fn.c("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room E(DataHolder dataHolder) {
        com.google.android.gms.games.multiplayer.realtime.a a2 = new com.google.android.gms.games.multiplayer.realtime.a(dataHolder);
        Room room = null;
        try {
            if (a2.getCount() > 0) {
                room = (Room)((Room)a2.get(0)).freeze();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            a2.close();
            throw throwable;
        }
        a2.close();
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.tT = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.F(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class av
    extends dw.b<a.c<Status>> {
        private final Status jY;

        public av(a.c<Status> c2, Status status) {
            super(fl.this, c2);
            this.jY = status;
        }

        public void c(a.c<Status> c2) {
            c2.a(this.jY);
        }

        @Override
        protected void aL() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class am
    extends dw.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int mC;
        private final String us;
        private final int ut;

        am(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, int n2, int n3, String string) {
            super(fl.this, reliableMessageSentCallback);
            this.mC = n2;
            this.ut = n3;
            this.us = string;
        }

        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.mC, this.ut, this.us);
            }
        }

        @Override
        protected void aL() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RealTimeMultiplayer.ReliableMessageSentCallback)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends dw.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage uo;

        z(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(fl.this, realTimeMessageReceivedListener);
            this.uo = realTimeMessage;
        }

        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.uo);
            }
        }

        @Override
        protected void aL() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RealTimeMessageReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends dw.b<RoomStatusUpdateListener> {
        private final String up;

        ab(RoomStatusUpdateListener roomStatusUpdateListener, String string) {
            super(fl.this, roomStatusUpdateListener);
            this.up = string;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.up);
            }
        }

        @Override
        protected void aL() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends dw.b<RoomStatusUpdateListener> {
        private final String up;

        aa(RoomStatusUpdateListener roomStatusUpdateListener, String string) {
            super(fl.this, roomStatusUpdateListener);
            this.up = string;
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.up);
            }
        }

        @Override
        protected void aL() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RoomStatusUpdateListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ae
    extends a {
        ae(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ad
    extends a {
        ad(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ah
    extends a {
        ah(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ag
    extends a {
        ag(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends a {
        af(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class ap
    extends c {
        ap(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class as
    extends c {
        as(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(roomStatusUpdateListener, dataHolder);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class ar
    extends b {
        ar(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends dw.b<RoomUpdateListener> {
        private final int mC;
        private final String uk;

        v(RoomUpdateListener roomUpdateListener, int n2, String string) {
            super(fl.this, roomUpdateListener);
            this.mC = n2;
            this.uk = string;
        }

        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.mC, this.uk);
        }

        @Override
        protected void aL() {
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((RoomUpdateListener)object);
        }
    }

    final class q
    extends b {
        public q(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class at
    extends b {
        public at(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(roomUpdateListener, dataHolder);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> tY;

        a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder, String[] stringArray) {
            super(roomStatusUpdateListener, dataHolder);
            this.tY = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.tY.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.tY);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends dw.d<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            super(fl.this, roomStatusUpdateListener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, fl.this.E(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends dw.d<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            super(fl.this, roomUpdateListener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, fl.this.E(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ba
    extends dw.b<a.c<TurnBasedMultiplayer.CancelMatchResult>>
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status jY;
        private final String uA;

        ba(a.c<TurnBasedMultiplayer.CancelMatchResult> c2, Status status, String string) {
            super(fl.this, c2);
            this.jY = status;
            this.uA = string;
        }

        public void c(a.c<TurnBasedMultiplayer.CancelMatchResult> c2) {
            c2.a(this);
        }

        @Override
        protected void aL() {
        }

        @Override
        public Status getStatus() {
            return this.jY;
        }

        @Override
        public String getMatchId() {
            return this.uA;
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class be
    extends ay<a.c<TurnBasedMultiplayer.LeaveMatchResult>>
    implements TurnBasedMultiplayer.LeaveMatchResult {
        be(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
        }

        @Override
        protected void i(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bi
    extends ay<a.c<TurnBasedMultiplayer.UpdateMatchResult>>
    implements TurnBasedMultiplayer.UpdateMatchResult {
        bi(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
        }

        @Override
        protected void i(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bc
    extends ay<a.c<TurnBasedMultiplayer.InitiateMatchResult>>
    implements TurnBasedMultiplayer.InitiateMatchResult {
        bc(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
        }

        @Override
        protected void i(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bg
    extends ay<a.c<TurnBasedMultiplayer.LoadMatchResult>>
    implements TurnBasedMultiplayer.LoadMatchResult {
        bg(a.c<TurnBasedMultiplayer.LoadMatchResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
        }

        @Override
        protected void i(a.c<TurnBasedMultiplayer.LoadMatchResult> c2) {
            c2.a(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ay<T extends a.c<?>>
    extends ao<T> {
        final TurnBasedMatch un;
        final /* synthetic */ fl tZ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ay(T t2, DataHolder dataHolder) {
            this.tZ = var1_1;
            super((fl)var1_1, t2, dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.un = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                turnBasedMatchBuffer.close();
                throw throwable;
            }
            turnBasedMatchBuffer.close();
        }

        @Override
        protected void a(T t2, DataHolder dataHolder) {
            this.i(t2);
        }

        abstract void i(T var1);

        public TurnBasedMatch getMatch() {
            return this.un;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ax
    extends ao<a.c<Leaderboards.SubmitScoreResult>>
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData uy;

        public ax(a.c<Leaderboards.SubmitScoreResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.uy = new ScoreSubmissionData(dataHolder);
        }

        @Override
        public void a(a.c<Leaderboards.SubmitScoreResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.uy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class al
    extends ao<a.c<Players.LoadPlayersResult>>
    implements Players.LoadPlayersResult {
        private final PlayerBuffer ur;

        al(a.c<Players.LoadPlayersResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.ur = new PlayerBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Players.LoadPlayersResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.ur;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bk
    extends dw.b<a.c<TurnBasedMultiplayer.LoadMatchesResult>>
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status jY;
        private final LoadMatchesResponse uG;

        bk(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2, Status status, Bundle bundle) {
            super(fl.this, c2);
            this.jY = status;
            this.uG = new LoadMatchesResponse(bundle);
        }

        protected void c(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2) {
            c2.a(this);
        }

        @Override
        protected void aL() {
        }

        @Override
        public Status getStatus() {
            return this.jY;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.uG;
        }

        @Override
        public void release() {
            this.uG.close();
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends dw.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String ul;

        w(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener, String string) {
            super(fl.this, onTurnBasedMatchUpdateReceivedListener);
            this.ul = string;
        }

        protected void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.ul);
        }

        @Override
        protected void aL() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends dw.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch un;

        y(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener, TurnBasedMatch turnBasedMatch) {
            super(fl.this, onTurnBasedMatchUpdateReceivedListener);
            this.un = turnBasedMatch;
        }

        protected void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.un);
        }

        @Override
        protected void aL() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class n
    extends dw.b<OnInvitationReceivedListener> {
        private final String uf;

        n(OnInvitationReceivedListener onInvitationReceivedListener, String string) {
            super(fl.this, onInvitationReceivedListener);
            this.uf = string;
        }

        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.uf);
        }

        @Override
        protected void aL() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnInvitationReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class m
    extends dw.b<OnInvitationReceivedListener> {
        private final Invitation ue;

        m(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(fl.this, onInvitationReceivedListener);
            this.ue = invitation;
        }

        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.ue);
        }

        @Override
        protected void aL() {
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.a((OnInvitationReceivedListener)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class p
    extends ao<a.c<Invitations.LoadInvitationsResult>>
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer ug;

        p(a.c<Invitations.LoadInvitationsResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.ug = new InvitationBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Invitations.LoadInvitationsResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.ug;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aj
    extends dw.d<a.c<Leaderboards.LoadPlayerScoreResult>>
    implements Leaderboards.LoadPlayerScoreResult {
        private final Status jY;
        private final com.google.android.gms.games.leaderboard.d uq;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        aj(a.c<Leaderboards.LoadPlayerScoreResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.jY = new Status(dataHolder.getStatusCode());
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(dataHolder);
            try {
                this.uq = leaderboardScoreBuffer.getCount() > 0 ? (com.google.android.gms.games.leaderboard.d)leaderboardScoreBuffer.get(0).freeze() : null;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                leaderboardScoreBuffer.close();
                throw throwable;
            }
            leaderboardScoreBuffer.close();
        }

        @Override
        protected void a(a.c<Leaderboards.LoadPlayerScoreResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public Status getStatus() {
            return this.jY;
        }

        @Override
        public LeaderboardScore getScore() {
            return this.uq;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class s
    extends ao<a.c<Leaderboards.LoadScoresResult>>
    implements Leaderboards.LoadScoresResult {
        private final com.google.android.gms.games.leaderboard.a uh;
        private final LeaderboardScoreBuffer ui;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        s(a.c<Leaderboards.LoadScoresResult> c2, DataHolder dataHolder, DataHolder dataHolder2) {
            super(fl.this, c2, dataHolder2);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(dataHolder);
            try {
                this.uh = leaderboardBuffer.getCount() > 0 ? (com.google.android.gms.games.leaderboard.a)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                leaderboardBuffer.close();
                throw throwable;
            }
            leaderboardBuffer.close();
            this.ui = new LeaderboardScoreBuffer(dataHolder2);
        }

        @Override
        protected void a(a.c<Leaderboards.LoadScoresResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.uh;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.ui;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends ao<a.c<Leaderboards.LeaderboardMetadataResult>>
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer uj;

        u(a.c<Leaderboards.LeaderboardMetadataResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.uj = new LeaderboardBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Leaderboards.LeaderboardMetadataResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.uj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class k
    extends ao<a.c<GamesMetadata.LoadGamesResult>>
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer uc;

        k(a.c<GamesMetadata.LoadGamesResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.uc = new GameBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<GamesMetadata.LoadGamesResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public GameBuffer getGames() {
            return this.uc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends dw.b<a.c<Achievements.UpdateAchievementResult>>
    implements Achievements.UpdateAchievementResult {
        private final Status jY;
        private final String ua;

        e(a.c<Achievements.UpdateAchievementResult> c2, int n2, String string) {
            super(fl.this, c2);
            this.jY = new Status(n2);
            this.ua = string;
        }

        protected void c(a.c<Achievements.UpdateAchievementResult> c2) {
            c2.a(this);
        }

        @Override
        protected void aL() {
        }

        @Override
        public Status getStatus() {
            return this.jY;
        }

        @Override
        public String getAchievementId() {
            return this.ua;
        }

        @Override
        protected /* synthetic */ void b(Object object) {
            this.c((a.c)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends ao<a.c<Achievements.LoadAchievementsResult>>
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer ub;

        g(a.c<Achievements.LoadAchievementsResult> c2, DataHolder dataHolder) {
            super(fl.this, c2, dataHolder);
            this.ub = new AchievementBuffer(dataHolder);
        }

        @Override
        protected void a(a.c<Achievements.LoadAchievementsResult> c2, DataHolder dataHolder) {
            c2.a(this);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.ub;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ao<R extends a.c<?>>
    extends dw.d<R>
    implements Releasable,
    Result {
        final Status jY;
        final DataHolder nE;
        final /* synthetic */ fl tZ;

        public ao(R r2, DataHolder dataHolder) {
            this.tZ = var1_1;
            super(var1_1, r2, dataHolder);
            this.jY = new Status(dataHolder.getStatusCode());
            this.nE = dataHolder;
        }

        @Override
        public Status getStatus() {
            return this.jY;
        }

        @Override
        public void release() {
            if (this.nE != null) {
                this.nE.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class au
    extends fk {
        private final a.c<Status> jW;

        public au(a.c<Status> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void onSignOutComplete() {
            Status status = new Status(0);
            fl.this.a(new av(this.jW, status));
        }
    }

    final class an
    extends fk {
        final RealTimeMultiplayer.ReliableMessageSentCallback uu;

        public an(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            this.uu = reliableMessageSentCallback;
        }

        public void b(int n2, int n3, String string) {
            fl.this.a(new am(this.uu, n2, n3, string));
        }
    }

    final class aq
    extends fk {
        private final RoomUpdateListener uv;
        private final RoomStatusUpdateListener uw;
        private final RealTimeMessageReceivedListener ux;

        public aq(RoomUpdateListener roomUpdateListener) {
            this.uv = eg.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.uw = null;
            this.ux = null;
        }

        public aq(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.uv = eg.b(roomUpdateListener, (Object)"Callbacks must not be null");
            this.uw = roomStatusUpdateListener;
            this.ux = realTimeMessageReceivedListener;
        }

        public void t(DataHolder dataHolder) {
            fl.this.a(new at(this.uv, dataHolder));
        }

        public void u(DataHolder dataHolder) {
            fl.this.a(new q(this.uv, dataHolder));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            fl.this.a(new v(this.uv, statusCode, externalRoomId));
        }

        public void x(DataHolder dataHolder) {
            fl.this.a(new ar(this.uv, dataHolder));
        }

        public void v(DataHolder dataHolder) {
            fl.this.a(new as(this.uw, dataHolder));
        }

        public void w(DataHolder dataHolder) {
            fl.this.a(new ap(this.uw, dataHolder));
        }

        public void y(DataHolder dataHolder) {
            fl.this.a(new h(this.uw, dataHolder));
        }

        public void z(DataHolder dataHolder) {
            fl.this.a(new i(this.uw, dataHolder));
        }

        public void e(DataHolder dataHolder, String[] stringArray) {
            fl.this.a(new ac(this.uw, dataHolder, stringArray));
        }

        public void f(DataHolder dataHolder, String[] stringArray) {
            fl.this.a(new ae(this.uw, dataHolder, stringArray));
        }

        public void a(DataHolder dataHolder, String[] stringArray) {
            fl.this.a(new af(this.uw, dataHolder, stringArray));
        }

        public void b(DataHolder dataHolder, String[] stringArray) {
            fl.this.a(new ag(this.uw, dataHolder, stringArray));
        }

        public void c(DataHolder dataHolder, String[] stringArray) {
            fl.this.a(new ah(this.uw, dataHolder, stringArray));
        }

        public void d(DataHolder dataHolder, String[] stringArray) {
            fl.this.a(new ad(this.uw, dataHolder, stringArray));
        }

        public void onP2PConnected(String participantId) {
            fl.this.a(new aa(this.uw, participantId));
        }

        public void onP2PDisconnected(String participantId) {
            fl.this.a(new ab(this.uw, participantId));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            fl.this.a(new z(this.ux, message));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class az
    extends fk {
        private final a.c<TurnBasedMultiplayer.CancelMatchResult> uz;

        public az(a.c<TurnBasedMultiplayer.CancelMatchResult> c2) {
            this.uz = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void onTurnBasedMatchCanceled(int statusCode, String matchId) {
            Status status = new Status(statusCode);
            fl.this.a(new ba(this.uz, status, matchId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bd
    extends fk {
        private final a.c<TurnBasedMultiplayer.LeaveMatchResult> uC;

        public bd(a.c<TurnBasedMultiplayer.LeaveMatchResult> c2) {
            this.uC = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            fl.this.a(new be(this.uC, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bh
    extends fk {
        private final a.c<TurnBasedMultiplayer.UpdateMatchResult> uE;

        public bh(a.c<TurnBasedMultiplayer.UpdateMatchResult> c2) {
            this.uE = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void o(DataHolder dataHolder) {
            fl.this.a(new bi(this.uE, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bb
    extends fk {
        private final a.c<TurnBasedMultiplayer.InitiateMatchResult> uB;

        public bb(a.c<TurnBasedMultiplayer.InitiateMatchResult> c2) {
            this.uB = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void n(DataHolder dataHolder) {
            fl.this.a(new bc(this.uB, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bf
    extends fk {
        private final a.c<TurnBasedMultiplayer.LoadMatchResult> uD;

        public bf(a.c<TurnBasedMultiplayer.LoadMatchResult> c2) {
            this.uD = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void m(DataHolder dataHolder) {
            fl.this.a(new bg(this.uD, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class bj
    extends fk {
        private final a.c<TurnBasedMultiplayer.LoadMatchesResult> uF;

        public bj(a.c<TurnBasedMultiplayer.LoadMatchesResult> c2) {
            this.uF = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            fl.this.a(new bk(this.uF, status, bundle));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aw
    extends fk {
        private final a.c<Leaderboards.SubmitScoreResult> jW;

        public aw(a.c<Leaderboards.SubmitScoreResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            fl.this.a(new ax(this.jW, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ak
    extends fk {
        private final a.c<Players.LoadPlayersResult> jW;

        ak(a.c<Players.LoadPlayersResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            fl.this.a(new al(this.jW, dataHolder));
        }
    }

    final class x
    extends fk {
        private final OnTurnBasedMatchUpdateReceivedListener um;

        x(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            this.um = onTurnBasedMatchUpdateReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void q(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                turnBasedMatchBuffer.close();
                throw throwable;
            }
            turnBasedMatchBuffer.close();
            if (turnBasedMatch != null) {
                fl.this.a(new y(this.um, turnBasedMatch));
            }
        }

        public void onTurnBasedMatchRemoved(String matchId) {
            fl.this.a(new w(this.um, matchId));
        }
    }

    final class l
    extends fk {
        private final OnInvitationReceivedListener ud;

        l(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.ud = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void l(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                invitationBuffer.close();
                throw throwable;
            }
            invitationBuffer.close();
            if (invitation != null) {
                fl.this.a(new m(this.ud, invitation));
            }
        }

        public void onInvitationRemoved(String invitationId) {
            fl.this.a(new n(this.ud, invitationId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class o
    extends fk {
        private final a.c<Invitations.LoadInvitationsResult> jW;

        o(a.c<Invitations.LoadInvitationsResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            fl.this.a(new p(this.jW, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ai
    extends fk {
        private final a.c<Leaderboards.LoadPlayerScoreResult> jW;

        ai(a.c<Leaderboards.LoadPlayerScoreResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            fl.this.a(new aj(this.jW, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class r
    extends fk {
        private final a.c<Leaderboards.LoadScoresResult> jW;

        r(a.c<Leaderboards.LoadScoresResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            fl.this.a(new s(this.jW, dataHolder, dataHolder2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class t
    extends fk {
        private final a.c<Leaderboards.LeaderboardMetadataResult> jW;

        t(a.c<Leaderboards.LeaderboardMetadataResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            fl.this.a(new u(this.jW, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class j
    extends fk {
        private final a.c<GamesMetadata.LoadGamesResult> jW;

        j(a.c<GamesMetadata.LoadGamesResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            fl.this.a(new k(this.jW, dataHolder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class d
    extends fk {
        private final a.c<Achievements.UpdateAchievementResult> jW;

        d(a.c<Achievements.UpdateAchievementResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void onAchievementUpdated(int statusCode, String achievementId) {
            fl.this.a(new e(this.jW, statusCode, achievementId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class f
    extends fk {
        private final a.c<Achievements.LoadAchievementsResult> jW;

        f(a.c<Achievements.LoadAchievementsResult> c2) {
            this.jW = eg.b(c2, (Object)"Holder must not be null");
        }

        @Override
        public void b(DataHolder dataHolder) {
            fl.this.a(new g(this.jW, dataHolder));
        }
    }
}

