/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ek<K, V> {
    private final LinkedHashMap<K, V> pQ;
    private int size;
    private int pR;
    private int pS;
    private int pT;
    private int pU;
    private int pV;
    private int pW;

    public ek(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.pR = n2;
        this.pQ = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        ek<K, V> ek2 = this;
        synchronized (ek2) {
            object = this.pQ.get(key);
            if (object != null) {
                ++this.pV;
                return object;
            }
            ++this.pW;
        }
        ek2 = this.create(key);
        if (ek2 == null) {
            return null;
        }
        ek ek3 = this;
        synchronized (ek3) {
            ++this.pT;
            object = this.pQ.put(key, ek2);
            if (object != null) {
                this.pQ.put(key, object);
            } else {
                this.size += this.c(key, ek2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, ek2, object);
            return object;
        }
        this.trimToSize(this.pR);
        return (V)ek2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v2;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        ek ek2 = this;
        synchronized (ek2) {
            ++this.pS;
            this.size += this.c(key, value);
            v2 = this.pQ.put(key, value);
            if (v2 != null) {
                this.size -= this.c(key, v2);
            }
        }
        if (v2 != null) {
            this.entryRemoved(false, key, v2, value);
        }
        this.trimToSize(this.pR);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v2;
            K k2;
            ek ek2 = this;
            synchronized (ek2) {
                if (this.size < 0 || this.pQ.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.pQ.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.pQ.entrySet().iterator().next();
                k2 = entry.getKey();
                v2 = entry.getValue();
                this.pQ.remove(k2);
                this.size -= this.c(k2, v2);
                ++this.pU;
            }
            this.entryRemoved(true, k2, v2, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int c(K k2, V v2) {
        int n2 = this.sizeOf(k2, v2);
        if (n2 < 0) {
            throw new IllegalStateException("Negative size: " + k2 + "=" + v2);
        }
        return n2;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n2 = this.pV + this.pW;
        int n3 = n2 != 0 ? 100 * this.pV / n2 : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.pR, this.pV, this.pW, n3);
    }
}

