/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.dx;
import com.google.android.gms.internal.dy;
import com.google.android.gms.internal.eb;
import com.google.android.gms.internal.ec;
import com.google.android.gms.internal.eg;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class dw<T extends IInterface>
implements GooglePlayServicesClient,
Api.a,
dx.b {
    private final Context mContext;
    final Handler mHandler;
    private T pe;
    private final ArrayList<b<?>> pf = new ArrayList();
    private f pg;
    private final String[] jF;
    boolean ph = false;
    boolean pi = false;
    private final dx ne;
    private final Object pj = new Object();
    public static final String[] pk = new String[]{"service_esmobile", "service_googleme"};

    protected dw(Context context, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = eg.f(context);
        this.ne = new dx(context, this, null);
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.jF = stringArray;
        this.registerConnectionCallbacks(eg.f(connectionCallbacks));
        this.registerConnectionFailedListener(eg.f(onConnectionFailedListener));
    }

    protected dw(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String am();

    protected abstract String an();

    protected abstract T p(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.ph = true;
        Object object = this.pj;
        synchronized (object) {
            this.pi = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.pg != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.pe = null;
            dy.s(this.mContext).b(this.am(), this.pg);
        }
        this.pg = new f();
        boolean bl2 = dy.s(this.mContext).a(this.am(), this.pg);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.am()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.pe != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.pj;
        synchronized (object) {
            return this.pi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.ph = false;
        ArrayList<b<?>> arrayList = this.pj;
        synchronized (arrayList) {
            this.pi = false;
        }
        arrayList = this.pf;
        synchronized (arrayList) {
            int n2 = this.pf.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.pf.get(i2).bS();
            }
            this.pf.clear();
        }
        this.pe = null;
        if (this.pg != null) {
            dy.s(this.mContext).b(this.am(), this.pg);
            this.pg = null;
            this.ne.J(-1);
        }
    }

    public void I(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] bO() {
        return this.jF;
    }

    protected final void w(IBinder iBinder) {
        try {
            ec ec2 = ec.a.y(iBinder);
            this.a(ec2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(ec var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void bP() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle aU() {
        return null;
    }

    protected final T bQ() {
        this.bP();
        return this.pe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.pf;
        synchronized (arrayList) {
            this.pf.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean bp() {
        return this.ph;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.ne.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.ne.registerConnectionFailedListener(listener);
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ne.registerConnectionCallbacks(new c(listener));
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.ne.isConnectionCallbacksRegistered(new c(listener));
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.ne.unregisterConnectionCallbacks(new c(listener));
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ne.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.ne.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.ne.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends eb.a {
        private dw po;

        public e(dw dw2) {
            this.po = dw2;
        }

        public void b(int n2, IBinder iBinder, Bundle bundle) {
            eg.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.po);
            this.po.a(n2, iBinder, bundle);
            this.po = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle pq;
        public final IBinder pr;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.pr = iBinder;
            this.pq = bundle;
        }

        @Override
        protected void b(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.pr.getInterfaceDescriptor();
                        if (dw.this.an().equals(string2)) {
                            dw.this.pe = dw.this.p(this.pr);
                            if (dw.this.pe != null) {
                                dw.this.ne.bT();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    dy.s(dw.this.mContext).b(dw.this.am(), dw.this.pg);
                    dw.this.pg = null;
                    dw.this.pe = null;
                    dw.this.ne.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.pq != null) {
                        pendingIntent = (PendingIntent)this.pq.getParcelable("pendingIntent");
                    }
                    if (dw.this.pg != null) {
                        dy.s(dw.this.mContext).b(dw.this.am(), dw.this.pg);
                        dw.this.pg = null;
                    }
                    dw.this.pe = null;
                    dw.this.ne.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void aL() {
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener pp;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.pp = onConnectionFailedListener;
        }

        public void onConnectionFailed(ConnectionResult result) {
            this.pp.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.pp.equals(((g)other).pp);
            }
            return this.pp.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks pn;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.pn = connectionCallbacks;
        }

        public void onConnected(Bundle connectionHint) {
            this.pn.onConnected(connectionHint);
        }

        public void onConnectionSuspended(int cause) {
            this.pn.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.pn.equals(((c)other).pn);
            }
            return this.pn.equals(other);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder nE;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.nE = dataHolder;
        }

        @Override
        protected final void b(TListener TListener) {
            this.a(TListener, this.nE);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void aL() {
            if (this.nE != null) {
                this.nE.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean pm;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.pm = false;
        }

        protected abstract void b(TListener var1);

        protected abstract void aL();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bR() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.pm) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.b(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.aL();
                    throw runtimeException;
                }
            } else {
                this.aL();
            }
            b2 = this;
            synchronized (b2) {
                this.pm = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.bS();
            ArrayList arrayList = dw.this.pf;
            synchronized (arrayList) {
                dw.this.pf.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bS() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1 && !dw.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.aL();
                b2.unregister();
                return;
            }
            Object object = dw.this.pj;
            synchronized (object) {
                dw.this.pi = false;
            }
            if (msg.what == 3) {
                dw.this.ne.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                dw.this.ne.J((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !dw.this.isConnected()) {
                object = (b)msg.obj;
                ((b)object).aL();
                ((b)object).unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).bR();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            dw.this.w(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            dw.this.pe = null;
            dw.this.ne.J(1);
        }
    }
}

