/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.internal.df;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.dn;
import com.google.android.gms.internal.do;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class dl
extends df {
    private static final long me = TimeUnit.SECONDS.toMillis(3L);
    private static final long mf = TimeUnit.HOURS.toMillis(24L);
    private static final long mg = TimeUnit.SECONDS.toMillis(5L);
    private static final long mh = TimeUnit.SECONDS.toMillis(1L);
    private long mi;
    private MediaStatus mj;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final do mk;
    private final do ml;
    private final do mm;
    private final do mn;
    private final do mo;
    private final Runnable mp = new a();
    private boolean mq;

    public dl() {
        super("urn:x-cast:com.google.cast.media", "MediaControlChannel");
        this.mk = new do(mf);
        this.ml = new do(mg);
        this.mm = new do(me);
        this.mn = new do(me);
        this.mo = new do(me);
        this.bd();
    }

    public long a(dn dn2, MediaInfo mediaInfo, boolean bl2, long l2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.aS();
        this.mk.a(l3, dn2);
        this.o(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.aP());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", dh.h(l2));
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public void c(JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.aS();
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.aQ());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
    }

    public void d(JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.aS();
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.aQ());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
    }

    public void e(JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.aS();
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.aQ());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
    }

    public long a(dn dn2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.aS();
        this.ml.a(l3, dn2);
        this.o(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.aQ());
            jSONObject2.put("currentTime", dh.h(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(dn dn2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.aS();
        this.mm.a(l2, dn2);
        this.o(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.aQ());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(dn dn2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.aS();
        this.mn.a(l2, dn2);
        this.o(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.aQ());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(dn dn2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.aS();
        this.mo.a(l2, dn2);
        this.o(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.mj != null) {
                jSONObject.put("mediaSessionId", this.mj.aQ());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.mi == 0L) {
            return 0L;
        }
        double d2 = this.mj.getPlaybackRate();
        long l2 = this.mj.getStreamPosition();
        int n2 = this.mj.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.mi;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = l2 + (long)((double)l3 * d2);
        long l5 = mediaInfo.getStreamDuration();
        if (l4 > l5) {
            l4 = l5;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.mj;
    }

    public MediaInfo getMediaInfo() {
        return this.mj == null ? null : this.mj.getMediaInfo();
    }

    public final void B(String string2) {
        this.lx.b("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.mj = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.mo.c(l2, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.lx.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                this.mk.b(l2, 1, jSONObject2);
                this.ml.b(l2, 1, jSONObject2);
                this.mm.b(l2, 1, jSONObject2);
                this.mn.b(l2, 1, jSONObject2);
                this.mo.b(l2, 1, jSONObject2);
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.mk.b(l2, 1, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.mk.b(l2, 2, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.lx.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                this.mk.b(l2, 1, jSONObject5);
                this.ml.b(l2, 1, jSONObject5);
                this.mm.b(l2, 1, jSONObject5);
                this.mn.b(l2, 1, jSONObject5);
                this.mo.b(l2, 1, jSONObject5);
            }
        }
        catch (JSONException jSONException) {
            this.lx.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    public void a(long l2, int n2) {
        this.mk.c(l2, n2);
        this.ml.c(l2, n2);
        this.mm.c(l2, n2);
        this.mn.c(l2, n2);
        this.mo.c(l2, n2);
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.mk.i(l2);
        boolean bl3 = this.ml.bf() && !this.ml.i(l2);
        boolean bl4 = this.mm.bf() && !this.mm.i(l2) || this.mn.bf() && !this.mn.i(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.mj == null) {
            this.mj = new MediaStatus(jSONObject);
            this.mi = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.mj.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.mi = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.mi = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        this.mk.c(l2, 0);
        this.ml.c(l2, 0);
        this.mm.c(l2, 0);
        this.mn.c(l2, 0);
        this.mo.c(l2, 0);
    }

    public long aQ() throws IllegalStateException {
        if (this.mj == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.mj.aQ();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void bd() {
        this.o(false);
        this.mi = 0L;
        this.mj = null;
        this.mk.clear();
        this.ml.clear();
        this.mm.clear();
    }

    public void aT() {
        this.bd();
    }

    private void o(boolean bl2) {
        if (this.mq != bl2) {
            this.mq = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.mp, mh);
            } else {
                this.mHandler.removeCallbacks(this.mp);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            dl.this.mq = false;
            long l2 = SystemClock.elapsedRealtime();
            dl.this.mk.d(l2, 3);
            dl.this.ml.d(l2, 3);
            dl.this.mm.d(l2, 3);
            dl.this.mn.d(l2, 3);
            dl.this.mo.d(l2, 3);
            boolean bl2 = false;
            Object object = do.mw;
            synchronized (object) {
                bl2 = dl.this.mk.bf() || dl.this.ml.bf() || dl.this.mm.bf() || dl.this.mn.bf() || dl.this.mo.bf();
            }
            dl.this.o(bl2);
        }
    }
}

