/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.di;
import com.google.android.gms.internal.dj;
import com.google.android.gms.internal.dk;
import com.google.android.gms.internal.dw;
import com.google.android.gms.internal.eb;
import com.google.android.gms.internal.ec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class dg
extends dw<di> {
    private static final dk lA = new dk("CastClientImpl");
    private ApplicationMetadata lB;
    private final CastDevice lC;
    private final Cast.Listener kw;
    private final Handler mHandler;
    private final dj lD;
    private final Map<String, Cast.MessageReceivedCallback> lE;
    private final long lF;
    private String lG;
    private boolean lc;
    private boolean lH;
    private boolean lI;
    private double lb;
    private final AtomicLong lJ;
    private String lK;
    private String lL;
    private Bundle lM;
    private Map<Long, a.c<Status>> lN;
    private a.c<Cast.ApplicationConnectionResult> lO;
    private a.c<Status> lP;
    private static final Object lQ = new Object();
    private static final Object lR = new Object();

    public dg(Context context, CastDevice castDevice, long l2, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, connectionCallbacks, onConnectionFailedListener, (String[])null);
        this.lC = castDevice;
        this.kw = listener;
        this.lF = l2;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.lE = new HashMap<String, Cast.MessageReceivedCallback>();
        this.lI = false;
        this.lB = null;
        this.lG = null;
        this.lb = 0.0;
        this.lc = false;
        this.lJ = new AtomicLong(0L);
        this.lN = new HashMap<Long, a.c<Status>>();
        this.lD = new dj.a(){

            public void t(int n2) {
                lA.b("ICastDeviceControllerListener.onDisconnected", new Object[0]);
                dg.this.lI = false;
                dg.this.lB = null;
                if (n2 != 0) {
                    dg.this.I(2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void a(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl2) {
                dg.this.lK = applicationMetadata.getApplicationId();
                dg.this.lL = string3;
                Object object = lQ;
                synchronized (object) {
                    if (dg.this.lO != null) {
                        dg.this.lO.a(new a(new Status(0), applicationMetadata, string2, string3, bl2));
                        dg.this.lO = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void u(int n2) {
                Object object = lQ;
                synchronized (object) {
                    if (dg.this.lO != null) {
                        dg.this.lO.a(new a(new Status(n2)));
                        dg.this.lO = null;
                    }
                }
            }

            public void v(int n2) {
                this.x(n2);
            }

            public void w(int n2) {
                this.x(n2);
            }

            public void onApplicationDisconnected(final int statusCode) {
                dg.this.lK = null;
                dg.this.lL = null;
                if (this.x(statusCode)) {
                    return;
                }
                if (dg.this.kw != null) {
                    dg.this.mHandler.post(new Runnable(){

                        public void run() {
                            if (dg.this.kw != null) {
                                dg.this.kw.onApplicationDisconnected(statusCode);
                            }
                        }
                    });
                }
            }

            public void b(final String string2, final double d2, final boolean bl2) {
                dg.this.mHandler.post(new Runnable(){

                    public void run() {
                        dg.this.a(string2, d2, bl2);
                    }
                });
            }

            public void a(final String string2, final String string3) {
                lA.b("Receive (type=text, ns=%s) %s", string2, string3);
                dg.this.mHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Cast.MessageReceivedCallback messageReceivedCallback;
                        Map map = dg.this.lE;
                        synchronized (map) {
                            messageReceivedCallback = (Cast.MessageReceivedCallback)dg.this.lE.get(string2);
                        }
                        if (messageReceivedCallback != null) {
                            messageReceivedCallback.onMessageReceived(dg.this.lC, string2, string3);
                        } else {
                            lA.b("Discarded message for unknown namespace '%s'", string2);
                        }
                    }
                });
            }

            public void b(String string2, byte[] byArray) {
                lA.b("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
            }

            public void a(String string2, long l2, int n2) {
                this.b(l2, n2);
            }

            public void a(String string2, long l2) {
                this.b(l2, 0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void b(long l2, int n2) {
                a.c c2 = null;
                Map map = dg.this.lN;
                synchronized (map) {
                    c2 = (a.c)dg.this.lN.remove(l2);
                }
                if (c2 != null) {
                    c2.a(new Status(n2));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean x(int n2) {
                Object object = lR;
                synchronized (object) {
                    if (dg.this.lP != null) {
                        dg.this.lP.a(new Status(n2));
                        dg.this.lP = null;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 || n2 == 1001) {
            this.lI = true;
            this.lH = true;
        } else {
            this.lI = false;
        }
        int n3 = n2;
        if (n2 == 1001) {
            this.lM = new Bundle();
            this.lM.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.a(n3, iBinder, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        try {
            block7: {
                try {
                    if (!this.isConnected()) break block7;
                    Map<String, Cast.MessageReceivedCallback> map = this.lE;
                    synchronized (map) {
                        this.lE.clear();
                    }
                    ((di)this.bQ()).disconnect();
                }
                catch (RemoteException remoteException) {
                    lA.b("Error while disconnecting the controller interface: %s", remoteException.getMessage());
                    Object var4_5 = null;
                    super.disconnect();
                }
            }
            Object var4_4 = null;
            super.disconnect();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            super.disconnect();
            throw throwable;
        }
    }

    @Override
    public Bundle aU() {
        if (this.lM != null) {
            Bundle bundle = this.lM;
            this.lM = null;
            return bundle;
        }
        return super.aU();
    }

    @Override
    protected String am() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    @Override
    protected String an() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected di u(IBinder iBinder) {
        return di.a.v(iBinder);
    }

    @Override
    protected void a(ec ec2, dw.e e2) throws RemoteException {
        Bundle bundle = new Bundle();
        lA.b("getServiceFromBroker(): mLastApplicationId=%s, mLastSessionId=%s", this.lK, this.lL);
        this.lC.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.lF);
        if (this.lK != null) {
            bundle.putString("last_application_id", this.lK);
            if (this.lL != null) {
                bundle.putString("last_session_id", this.lL);
            }
        }
        ec2.a((eb)e2, 4242000, this.getContext().getPackageName(), this.lD.asBinder(), bundle);
    }

    public void a(String string2, String string3, a.c<Status> c2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string2 == null || string2.length() > 128) {
            throw new IllegalArgumentException("Invalid namespace length");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        this.aX();
        long l2 = this.lJ.incrementAndGet();
        ((di)this.bQ()).a(string2, string3, l2);
        this.lN.put(l2, c2);
    }

    public void a(String string2, boolean bl2, a.c<Cast.ApplicationConnectionResult> c2) throws IllegalStateException, RemoteException {
        this.d(c2);
        ((di)this.bQ()).c(string2, bl2);
    }

    public void b(String string2, String string3, a.c<Cast.ApplicationConnectionResult> c2) throws IllegalStateException, RemoteException {
        this.d(c2);
        ((di)this.bQ()).b(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(a.c<Cast.ApplicationConnectionResult> c2) {
        Object object = lQ;
        synchronized (object) {
            if (this.lO != null) {
                this.lO.a(new a(new Status(2002)));
            }
            this.lO = c2;
        }
    }

    public void e(a.c<Status> c2) throws IllegalStateException, RemoteException {
        this.f(c2);
        ((di)this.bQ()).bb();
    }

    public void a(String string2, a.c<Status> c2) throws IllegalStateException, RemoteException {
        this.f(c2);
        ((di)this.bQ()).D(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void f(a.c<Status> c2) {
        Object object = lR;
        synchronized (object) {
            if (this.lP != null) {
                c2.a(new Status(2001));
                return;
            }
            this.lP = c2;
        }
    }

    public void aV() throws IllegalStateException, RemoteException {
        ((di)this.bQ()).aV();
    }

    public void a(double d2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        ((di)this.bQ()).a(d2, this.lb, this.lc);
    }

    public void n(boolean bl2) throws IllegalStateException, RemoteException {
        ((di)this.bQ()).a(bl2, this.lb, this.lc);
    }

    public double aW() throws IllegalStateException {
        this.aX();
        return this.lb;
    }

    public boolean isMute() throws IllegalStateException {
        this.aX();
        return this.lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        this.C(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.lE;
            synchronized (map) {
                this.lE.put(string2, messageReceivedCallback);
            }
            ((di)this.bQ()).E(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void C(String string2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.lE;
        synchronized (map) {
            messageReceivedCallback = this.lE.remove(string2);
        }
        if (messageReceivedCallback != null) {
            ((di)this.bQ()).F(string2);
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.aX();
        return this.lB;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.aX();
        return this.lG;
    }

    private void a(String string2, double d2, boolean bl2) {
        boolean bl3 = false;
        if (!dh.a(string2, this.lG)) {
            this.lG = string2;
            bl3 = true;
        }
        if (this.kw != null && (bl3 || this.lH)) {
            this.kw.onApplicationStatusChanged();
        }
        bl3 = false;
        if (d2 != this.lb) {
            this.lb = d2;
            bl3 = true;
        }
        if (bl2 != this.lc) {
            this.lc = bl2;
            bl3 = true;
        }
        lA.b("hasChange=%b, mFirstStatusUpdate=%b", bl3, this.lH);
        if (this.kw != null && (bl3 || this.lH)) {
            this.kw.onVolumeChanged();
        }
        this.lH = false;
    }

    private void aX() throws IllegalStateException {
        if (!this.lI) {
            throw new IllegalStateException("not connected to a device");
        }
    }

    @Override
    protected /* synthetic */ IInterface p(IBinder iBinder) {
        return this.u(iBinder);
    }

    private static final class a
    implements Cast.ApplicationConnectionResult {
        private final Status jY;
        private final ApplicationMetadata lX;
        private final String lY;
        private final String lZ;
        private final boolean ma;

        public a(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl2) {
            this.jY = status;
            this.lX = applicationMetadata;
            this.lY = string2;
            this.lZ = string3;
            this.ma = bl2;
        }

        public a(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.jY;
        }

        public ApplicationMetadata getApplicationMetadata() {
            return this.lX;
        }

        public String getApplicationStatus() {
            return this.lY;
        }

        public String getSessionId() {
            return this.lZ;
        }

        public boolean getWasLaunched() {
            return this.ma;
        }
    }
}

