/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.bk;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cp;
import com.google.android.gms.internal.cq;
import com.google.android.gms.internal.ct;
import com.google.android.gms.internal.cu;
import com.google.android.gms.internal.cx;
import com.google.android.gms.internal.cy;
import com.google.android.gms.internal.cz;
import com.google.android.gms.internal.da;
import com.google.android.gms.internal.h;
import com.google.android.gms.internal.x;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class cw
extends WebView
implements DownloadListener {
    private final cx iN;
    private final a iO;
    private final Object fx = new Object();
    private final h he;
    private final cu fV;
    private bk iP;
    private x fU;
    private boolean iQ;
    private boolean iR;

    public static cw a(Context context, x x2, boolean bl2, boolean bl3, h h2, cu cu2) {
        a a2 = new a(context);
        return new cw(a2, x2, bl2, bl3, h2, cu2);
    }

    private cw(a a2, x x2, boolean bl2, boolean bl3, h h2, cu cu2) {
        super((Context)a2);
        this.iO = a2;
        this.fU = x2;
        this.iQ = bl2;
        this.he = h2;
        this.fV = cu2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        co.a((Context)a2, cu2.iJ, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            cq.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            cp.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.iN = Build.VERSION.SDK_INT >= 11 ? new cz(this, bl3) : new cx(this, bl3);
        this.setWebViewClient(this.iN);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new da(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new cy(this));
        }
        this.aG();
    }

    public void a(String string2, Map<String, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        if (map != null) {
            try {
                String string3 = co.m(map).toString();
                stringBuilder.append(",");
                stringBuilder.append(string3);
            }
            catch (JSONException jSONException) {
                ct.v("Could not convert AFMA event parameters to JSON.");
                return;
            }
        }
        stringBuilder.append(");");
        ct.u("Dispatching AFMA event: " + stringBuilder);
        this.loadUrl(stringBuilder.toString());
    }

    public void az() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.fV.iJ);
        this.a("onhide", hashMap);
    }

    public void aA() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.fV.iJ);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public bk aB() {
        Object object = this.fx;
        synchronized (object) {
            return this.iP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public x y() {
        Object object = this.fx;
        synchronized (object) {
            return this.fU;
        }
    }

    public cx aC() {
        return this.iN;
    }

    public h aD() {
        return this.he;
    }

    public cu aE() {
        return this.fV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aF() {
        Object object = this.fx;
        synchronized (object) {
            return this.iQ;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            ct.r("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.he != null) {
            this.he.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.fx;
        synchronized (object) {
            if (this.isInEditMode() || this.iQ) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.fU.widthPixels > n6 || this.fU.heightPixels > n7) {
                ct.v("Not enough space to show ad. Needs " + this.fU.widthPixels + "x" + this.fU.heightPixels + " pixels, but only has " + n3 + "x" + n5 + " pixels.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.fU.widthPixels, this.fU.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, x x2) {
        Object object = this.fx;
        synchronized (object) {
            this.iO.setBaseContext(context);
            this.iP = null;
            this.fU = x2;
            this.iQ = false;
            co.b(this);
            this.loadUrl("about:blank");
            this.iN.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(bk bk2) {
        Object object = this.fx;
        synchronized (object) {
            this.iP = bk2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(x x2) {
        Object object = this.fx;
        synchronized (object) {
            this.fU = x2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void l(boolean bl2) {
        Object object = this.fx;
        synchronized (object) {
            this.iQ = bl2;
            this.aG();
        }
    }

    public void setContext(Context context) {
        this.iO.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aG() {
        Object object = this.fx;
        synchronized (object) {
            if (this.iQ || this.fU.eG) {
                if (Build.VERSION.SDK_INT < 14) {
                    ct.r("Disabling hardware acceleration on an overlay.");
                    this.aH();
                } else {
                    ct.r("Enabling hardware acceleration on an overlay.");
                    this.aI();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                ct.r("Disabling hardware acceleration on an AdView.");
                this.aH();
            } else {
                ct.r("Enabling hardware acceleration on an AdView.");
                this.aI();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aH() {
        Object object = this.fx;
        synchronized (object) {
            if (!this.iR && Build.VERSION.SDK_INT >= 11) {
                cp.c((View)this);
            }
            this.iR = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aI() {
        Object object = this.fx;
        synchronized (object) {
            if (this.iR && Build.VERSION.SDK_INT >= 11) {
                cp.d((View)this);
            }
            this.iR = false;
        }
    }

    private static class a
    extends MutableContextWrapper {
        private Activity iS;
        private Context iT;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.iT = base.getApplicationContext();
            this.iS = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.iT);
        }

        public void startActivity(Intent intent) {
            if (this.iS != null) {
                this.iS.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.iT.startActivity(intent);
            }
        }
    }
}

