/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.internal.co;
import com.google.android.gms.internal.cs;
import java.util.Locale;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ci {
    public final int hZ;
    public final boolean ia;
    public final boolean ib;
    public final String ic;
    public final String id;
    public final boolean ie;
    public final boolean if;
    public final boolean ig;
    public final String ih;
    public final String ii;
    public final int ij;
    public final int ik;
    public final int il;
    public final int im;
    public final int in;
    public final int io;
    public final float ip;
    public final int iq;
    public final int ir;

    public ci(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Locale locale = Locale.getDefault();
        PackageManager packageManager = context.getPackageManager();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.hZ = audioManager.getMode();
        this.ia = ci.a(packageManager, "geo:0,0?q=donuts") != null;
        this.ib = ci.a(packageManager, "http://www.google.com") != null;
        this.ic = telephonyManager.getNetworkOperator();
        this.id = locale.getCountry();
        this.ie = cs.ax();
        this.if = audioManager.isMusicActive();
        this.ig = audioManager.isSpeakerphoneOn();
        this.ih = locale.getLanguage();
        this.ii = ci.a(packageManager);
        this.ij = audioManager.getStreamVolume(3);
        this.ik = ci.a(context, connectivityManager, packageManager);
        this.il = telephonyManager.getNetworkType();
        this.im = telephonyManager.getPhoneType();
        this.in = audioManager.getRingerMode();
        this.io = audioManager.getStreamVolume(2);
        this.ip = displayMetrics.density;
        this.iq = displayMetrics.widthPixels;
        this.ir = displayMetrics.heightPixels;
    }

    private static String a(PackageManager packageManager) {
        ResolveInfo resolveInfo = ci.a(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
            return packageInfo != null ? packageInfo.versionCode + "." + activityInfo.packageName : null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static int a(Context context, ConnectivityManager connectivityManager, PackageManager packageManager) {
        int n2 = -2;
        if (co.a(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            n2 = networkInfo != null ? networkInfo.getType() : -1;
        }
        return n2;
    }

    private static ResolveInfo a(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }
}

