/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.ee;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int kg;
    private final GameEntity wj;
    private final String ul;
    private final String wL;
    private final long wk;
    private final String wU;
    private final long wV;
    private final String wW;
    private final int wX;
    private final int wo;
    private final int wY;
    private final byte[] wZ;
    private final ArrayList<ParticipantEntity> wn;
    private final String xa;
    private final byte[] xb;
    private final int xc;
    private final Bundle wH;
    private final int xd;
    private final boolean xe;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.kg = 2;
        this.wj = new GameEntity(match.getGame());
        this.ul = match.getMatchId();
        this.wL = match.getCreatorId();
        this.wk = match.getCreationTimestamp();
        this.wU = match.getLastUpdaterId();
        this.wV = match.getLastUpdatedTimestamp();
        this.wW = match.getPendingParticipantId();
        this.wX = match.getStatus();
        this.xd = match.getTurnStatus();
        this.wo = match.getVariant();
        this.wY = match.getVersion();
        this.xa = match.getRematchId();
        this.xc = match.getMatchNumber();
        this.wH = match.getAutoMatchCriteria();
        this.xe = match.isLocallyModified();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.wZ = null;
        } else {
            this.wZ = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.wZ, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.xb = null;
        } else {
            this.xb = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.xb, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.wn = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.wn.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified) {
        this.kg = versionCode;
        this.wj = game;
        this.ul = matchId;
        this.wL = creatorId;
        this.wk = creationTimestamp;
        this.wU = lastUpdaterId;
        this.wV = lastUpdatedTimestamp;
        this.wW = pendingParticipantId;
        this.wX = matchStatus;
        this.xd = turnStatus;
        this.wo = variant;
        this.wY = version;
        this.wZ = data;
        this.wn = participants;
        this.xa = rematchId;
        this.xb = previousData;
        this.xc = matchNumber;
        this.wH = autoMatchCriteria;
        this.xe = isLocallyModified;
    }

    public int getVersionCode() {
        return this.kg;
    }

    @Override
    public Game getGame() {
        return this.wj;
    }

    @Override
    public String getMatchId() {
        return this.ul;
    }

    @Override
    public String getCreatorId() {
        return this.wL;
    }

    @Override
    public long getCreationTimestamp() {
        return this.wk;
    }

    @Override
    public String getLastUpdaterId() {
        return this.wU;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.wV;
    }

    @Override
    public String getPendingParticipantId() {
        return this.wW;
    }

    @Override
    public int getStatus() {
        return this.wX;
    }

    @Override
    public int getTurnStatus() {
        return this.xd;
    }

    @Override
    public int getVariant() {
        return this.wo;
    }

    @Override
    public byte[] getData() {
        return this.wZ;
    }

    @Override
    public int getVersion() {
        return this.wY;
    }

    @Override
    public String getRematchId() {
        return this.xa;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.xb;
    }

    @Override
    public int getMatchNumber() {
        return this.xc;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.wH;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.wH == null) {
            return 0;
        }
        return this.wH.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.wX == 2 && this.xa == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.xe;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.wn);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return ee.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return ee.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && ee.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && ee.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && ee.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && ee.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && ee.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && ee.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && ee.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && ee.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && ee.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && ee.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && ee.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && ee.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && ee.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && ee.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && ee.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && ee.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return ee.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string) {
        String string2 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + turnBasedMatch.getMatchId());
    }
}

