/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.internal.eg;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int wo;
    private final String[] wG;
    private final Bundle wH;
    private final int wT;

    private TurnBasedMatchConfig(Builder builder) {
        this.wo = builder.wo;
        this.wT = builder.wT;
        this.wH = builder.wH;
        int n2 = builder.wK.size();
        this.wG = builder.wK.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.wo;
    }

    public int getMinPlayers() {
        return this.wT;
    }

    public String[] getInvitedPlayerIds() {
        return this.wG;
    }

    public Bundle getAutoMatchCriteria() {
        return this.wH;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        int wo = -1;
        ArrayList<String> wK = new ArrayList();
        Bundle wH = null;
        int wT = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            eg.f(playerId);
            this.wK.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            eg.f(playerIds);
            this.wK.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            eg.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.wo = variant;
            return this;
        }

        public Builder setMinPlayers(int minPlayers) {
            this.wT = minPlayers;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.wH = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

