/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.eg;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener wD;
    private final RoomStatusUpdateListener wE;
    private final RealTimeMessageReceivedListener wF;
    private final String uf;
    private final int wo;
    private final String[] wG;
    private final Bundle wH;
    private final boolean wI;

    private RoomConfig(Builder builder) {
        this.wD = builder.wD;
        this.wE = builder.wE;
        this.wF = builder.wF;
        this.uf = builder.wJ;
        this.wo = builder.wo;
        this.wH = builder.wH;
        this.wI = builder.wI;
        int n2 = builder.wK.size();
        this.wG = builder.wK.toArray(new String[n2]);
        if (this.wF == null) {
            eg.a(this.wI, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.wD;
    }

    public String getInvitationId() {
        return this.uf;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.wE;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.wF;
    }

    public int getVariant() {
        return this.wo;
    }

    public String[] getInvitedPlayerIds() {
        return this.wG;
    }

    public Bundle getAutoMatchCriteria() {
        return this.wH;
    }

    public boolean isSocketEnabled() {
        return this.wI;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener wD;
        RoomStatusUpdateListener wE;
        RealTimeMessageReceivedListener wF;
        String wJ = null;
        int wo = -1;
        ArrayList<String> wK = new ArrayList();
        Bundle wH;
        boolean wI = false;

        private Builder(RoomUpdateListener updateListener) {
            this.wD = eg.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            eg.f(invitationId);
            this.wJ = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.wE = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.wF = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            eg.f(playerIds);
            this.wK.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            eg.f(playerIds);
            this.wK.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            eg.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.wo = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.wI = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.wH = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

