/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.c;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fm;

public final class ParticipantEntity
extends fm
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new a();
    private final int kg;
    private final String up;
    private final String qa;
    private final Uri sL;
    private final Uri sM;
    private final int wr;
    private final String ws;
    private final boolean wt;
    private final PlayerEntity wu;
    private final int wv;
    private final ParticipantResult ww;

    public ParticipantEntity(Participant participant) {
        this.kg = 2;
        this.up = participant.getParticipantId();
        this.qa = participant.getDisplayName();
        this.sL = participant.getIconImageUri();
        this.sM = participant.getHiResImageUri();
        this.wr = participant.getStatus();
        this.ws = participant.dy();
        this.wt = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.wu = player == null ? null : new PlayerEntity(player);
        this.wv = participant.getCapabilities();
        this.ww = participant.getResult();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result) {
        this.kg = versionCode;
        this.up = participantId;
        this.qa = displayName;
        this.sL = iconImageUri;
        this.sM = hiResImageUri;
        this.wr = status;
        this.ws = clientAddress;
        this.wt = connectedToRoom;
        this.wu = player;
        this.wv = capabilities;
        this.ww = result;
    }

    public int getVersionCode() {
        return this.kg;
    }

    public int getStatus() {
        return this.wr;
    }

    public String dy() {
        return this.ws;
    }

    public boolean isConnectedToRoom() {
        return this.wt;
    }

    public String getDisplayName() {
        if (this.wu == null) {
            return this.qa;
        }
        return this.wu.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.wu == null) {
            fc.b(this.qa, dataOut);
            return;
        }
        this.wu.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.wu == null) {
            return this.sL;
        }
        return this.wu.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.wu == null) {
            return this.sM;
        }
        return this.wu.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.up;
    }

    public Player getPlayer() {
        return this.wu;
    }

    public ParticipantResult getResult() {
        return this.ww;
    }

    public int getCapabilities() {
        return this.wv;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return ee.hashCode(participant.getPlayer(), participant.getStatus(), participant.dy(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return ee.equal(participant2.getPlayer(), participant.getPlayer()) && ee.equal(participant2.getStatus(), participant.getStatus()) && ee.equal(participant2.dy(), participant.dy()) && ee.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && ee.equal(participant2.getDisplayName(), participant.getDisplayName()) && ee.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && ee.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && ee.equal(participant2.getCapabilities(), participant.getCapabilities()) && ee.equal(participant2.getResult(), participant.getResult());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return ee.e(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.dy()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bN()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.up);
            dest.writeString(this.qa);
            dest.writeString(this.sL == null ? null : this.sL.toString());
            dest.writeString(this.sM == null ? null : this.sM.toString());
            dest.writeInt(this.wr);
            dest.writeString(this.ws);
            dest.writeInt(this.wt ? 1 : 0);
            dest.writeInt(this.wu == null ? 0 : 1);
            if (this.wu != null) {
                this.wu.writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends c {
        a() {
        }

        public ParticipantEntity ab(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.bM());
            if (bl2 || ParticipantEntity.P(ParticipantEntity.class.getCanonicalName())) {
                return super.ab(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            String string4 = parcel.readString();
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            int n2 = parcel.readInt();
            String string5 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(2, string, string2, uri, uri2, n2, string5, bl3, playerEntity, n3, participantResult);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.ab(x0);
        }
    }
}

