/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.fc;

public final class d
implements LeaderboardScore {
    private final long vK;
    private final String vL;
    private final String vM;
    private final long vN;
    private final long vO;
    private final String vP;
    private final Uri vQ;
    private final Uri vR;
    private final PlayerEntity vS;
    private final String vT;

    public d(LeaderboardScore leaderboardScore) {
        this.vK = leaderboardScore.getRank();
        this.vL = eg.f(leaderboardScore.getDisplayRank());
        this.vM = eg.f(leaderboardScore.getDisplayScore());
        this.vN = leaderboardScore.getRawScore();
        this.vO = leaderboardScore.getTimestampMillis();
        this.vP = leaderboardScore.getScoreHolderDisplayName();
        this.vQ = leaderboardScore.getScoreHolderIconImageUri();
        this.vR = leaderboardScore.getScoreHolderHiResImageUri();
        Player player = leaderboardScore.getScoreHolder();
        this.vS = player == null ? null : (PlayerEntity)player.freeze();
        this.vT = leaderboardScore.getScoreTag();
    }

    public long getRank() {
        return this.vK;
    }

    public String getDisplayRank() {
        return this.vL;
    }

    public void getDisplayRank(CharArrayBuffer dataOut) {
        fc.b(this.vL, dataOut);
    }

    public String getDisplayScore() {
        return this.vM;
    }

    public void getDisplayScore(CharArrayBuffer dataOut) {
        fc.b(this.vM, dataOut);
    }

    public long getRawScore() {
        return this.vN;
    }

    public long getTimestampMillis() {
        return this.vO;
    }

    public String getScoreHolderDisplayName() {
        if (this.vS == null) {
            return this.vP;
        }
        return this.vS.getDisplayName();
    }

    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.vS == null) {
            fc.b(this.vP, dataOut);
            return;
        }
        this.vS.getDisplayName(dataOut);
    }

    public Uri getScoreHolderIconImageUri() {
        if (this.vS == null) {
            return this.vQ;
        }
        return this.vS.getIconImageUri();
    }

    public Uri getScoreHolderHiResImageUri() {
        if (this.vS == null) {
            return this.vR;
        }
        return this.vS.getHiResImageUri();
    }

    public Player getScoreHolder() {
        return this.vS;
    }

    public String getScoreTag() {
        return this.vT;
    }

    public LeaderboardScore ds() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return d.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return ee.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return d.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return ee.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && ee.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && ee.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && ee.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && ee.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && ee.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && ee.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && ee.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && ee.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && ee.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return d.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return ee.e(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.ds();
    }
}

