/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.content.ContentValues;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.ge;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] wh = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String vD;
    private String tC;
    private int mC;
    private HashMap<Integer, Result> wi;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.mC = dataHolder.getStatusCode();
        this.wi = new HashMap();
        int n2 = dataHolder.getCount();
        eg.r(n2 == 3);
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            int n3 = dataHolder.C(i2);
            if (i2 == 0) {
                this.vD = dataHolder.getString("leaderboardId", i2, n3);
                this.tC = dataHolder.getString("playerId", i2, n3);
            }
            if (!(bl2 = dataHolder.getBoolean("hasResult", i2, n3))) continue;
            Result result = new Result(dataHolder.getLong("rawScore", i2, n3), dataHolder.getString("formattedScore", i2, n3), dataHolder.getString("scoreTag", i2, n3), dataHolder.getBoolean("newBest", i2, n3));
            this.a(result, dataHolder.getInteger("timeSpan", i2, n3));
        }
    }

    public DataHolder dx() {
        DataHolder.Builder builder = DataHolder.builder(wh);
        for (int i2 = 0; i2 < 3; ++i2) {
            builder.withRow(this.aH(i2));
        }
        return builder.build(this.mC);
    }

    private ContentValues aH(int n2) {
        Result result = this.getScoreResult(n2);
        ContentValues contentValues = new ContentValues();
        contentValues.put("leaderboardId", this.vD);
        contentValues.put("playerId", this.tC);
        contentValues.put("timeSpan", Integer.valueOf(n2));
        if (result != null) {
            contentValues.put("rawScore", Long.valueOf(result.rawScore));
            contentValues.put("formattedScore", result.formattedScore);
            contentValues.put("scoreTag", result.scoreTag);
            contentValues.put("newBest", Boolean.valueOf(result.newBest));
            contentValues.put("hasResult", Boolean.valueOf(true));
        } else {
            contentValues.put("hasResult", Boolean.valueOf(false));
        }
        return contentValues;
    }

    public String getLeaderboardId() {
        return this.vD;
    }

    public String getPlayerId() {
        return this.tC;
    }

    public Result getScoreResult(int timeSpan) {
        return this.wi.get(timeSpan);
    }

    private void a(Result result, int n2) {
        this.wi.put(n2, result);
    }

    public String toString() {
        ee.a a2 = ee.e(this).a("PlayerId", this.tC).a("StatusCode", this.mC);
        for (int i2 = 0; i2 < 3; ++i2) {
            Result result = this.wi.get(i2);
            a2.a("TimesSpan", ge.aG(i2));
            a2.a("Result", result == null ? "null" : result.toString());
        }
        return a2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return ee.e(this).a("RawScore", this.rawScore).a("FormattedScore", this.formattedScore).a("ScoreTag", this.scoreTag).a("NewBest", this.newBest).toString();
        }
    }
}

