/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.c;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fm;

public final class PlayerEntity
extends fm
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new a();
    private final int kg;
    private final String tC;
    private final String qa;
    private final Uri sL;
    private final Uri sM;
    private final long tD;
    private final int tE;
    private final long tF;

    public PlayerEntity(Player player) {
        this.kg = 3;
        this.tC = player.getPlayerId();
        this.qa = player.getDisplayName();
        this.sL = player.getIconImageUri();
        this.sM = player.getHiResImageUri();
        this.tD = player.getRetrievedTimestamp();
        this.tE = player.db();
        this.tF = player.getLastPlayedWithTimestamp();
        ds.d(this.tC);
        ds.d(this.qa);
        ds.p(this.tD > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp) {
        this.kg = versionCode;
        this.tC = playerId;
        this.qa = displayName;
        this.sL = iconImageUri;
        this.sM = hiResImageUri;
        this.tD = retrievedTimestamp;
        this.tE = isInCircles;
        this.tF = lastPlayedWithTimestamp;
    }

    public int getVersionCode() {
        return this.kg;
    }

    public String getPlayerId() {
        return this.tC;
    }

    public String getDisplayName() {
        return this.qa;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        fc.b(this.qa, dataOut);
    }

    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    public Uri getIconImageUri() {
        return this.sL;
    }

    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    public Uri getHiResImageUri() {
        return this.sM;
    }

    public long getRetrievedTimestamp() {
        return this.tD;
    }

    public long getLastPlayedWithTimestamp() {
        return this.tF;
    }

    public int db() {
        return this.tE;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    static int a(Player player) {
        return ee.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return ee.equal(player2.getPlayerId(), player.getPlayerId()) && ee.equal(player2.getDisplayName(), player.getDisplayName()) && ee.equal(player2.getIconImageUri(), player.getIconImageUri()) && ee.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && ee.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    static String b(Player player) {
        return ee.e(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("HiResImageUri", player.getHiResImageUri()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bN()) {
            c.a(this, dest, flags);
        } else {
            dest.writeString(this.tC);
            dest.writeString(this.qa);
            dest.writeString(this.sL == null ? null : this.sL.toString());
            dest.writeString(this.sM == null ? null : this.sM.toString());
            dest.writeLong(this.tD);
        }
    }

    static final class a
    extends c {
        a() {
        }

        public PlayerEntity Z(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.bM());
            if (bl2 || PlayerEntity.P(PlayerEntity.class.getCanonicalName())) {
                return super.Z(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string3 == null ? null : Uri.parse((String)string3);
            Uri uri2 = string4 == null ? null : Uri.parse((String)string4);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            return new PlayerEntity(3, string, string2, uri, uri2, l2, n2, l3);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.Z(x0);
        }
    }
}

