/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fs;
import com.google.android.gms.internal.ft;
import com.google.android.gms.internal.fu;
import com.google.android.gms.internal.fv;
import com.google.android.gms.internal.fw;
import com.google.android.gms.internal.fx;
import com.google.android.gms.internal.fy;
import com.google.android.gms.internal.fz;
import com.google.android.gms.internal.ga;
import com.google.android.gms.internal.gb;
import com.google.android.gms.internal.gg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Games {
    static final Api.b<fl> jO = new Api.b<fl>(){

        public fl e(Context context, dt dt2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            GamesOptions gamesOptions = new GamesOptions();
            if (apiOptions != null) {
                eg.b(apiOptions instanceof GamesOptions, (Object)"Must provide valid GamesOptions!");
                gamesOptions = (GamesOptions)apiOptions;
            }
            return new fl(context, dt2.bJ(), dt2.bF(), connectionCallbacks, onConnectionFailedListener, dt2.bI(), dt2.bG(), dt2.bK(), gamesOptions.ta, gamesOptions.tb, gamesOptions.tc, gamesOptions.td);
        }

        @Override
        public int getPriority() {
            return 1;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, dt dt2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.e(context, dt2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api API = new Api(jO, SCOPE_GAMES);
    public static final Scope sW = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api sX = new Api(jO, sW);
    public static final GamesMetadata GamesMetadata = new fu();
    public static final Achievements Achievements = new fs();
    public static final Leaderboards Leaderboards = new fw();
    public static final Invitations Invitations = new fv();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new gb();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new ga();
    public static final Multiplayer sY = new fx();
    public static final Players Players = new fz();
    public static final Notifications Notifications = new fy();
    public static final gg sZ = new ft();

    private Games() {
    }

    public static fl j(GoogleApiClient googleApiClient) {
        eg.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        eg.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        fl fl2 = googleApiClient.a(jO);
        eg.a(fl2 != null, "GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return fl2;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        Games.j(apiClient).setGravityForPopups(gravity);
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        eg.f(gamesContentView);
        Games.j(apiClient).setViewForPopups(gamesContentView);
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.j(apiClient).getCurrentAccountName();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.j(apiClient).getAppId();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.j(apiClient).getSettingsIntent();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            protected void a(fl fl2) {
                fl2.b(this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.j(apiClient).dd();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends a<Status> {
        private b() {
        }

        public Status g(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.g(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class a<R extends Result>
    extends a.a<R, fl>
    implements PendingResult<R> {
        public a() {
            super(jO);
        }
    }

    public static final class GamesOptions
    implements GoogleApiClient.ApiOptions {
        final boolean ta;
        final boolean tb;
        final int tc;
        final int td;

        private GamesOptions() {
            this.ta = false;
            this.tb = true;
            this.tc = 17;
            this.td = 4368;
        }

        private GamesOptions(Builder builder) {
            this.ta = builder.ta;
            this.tb = builder.tb;
            this.tc = builder.tc;
            this.td = builder.td;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean ta = false;
            boolean tb = true;
            int tc = 17;
            int td = 4368;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.tb = showConnectingPopup;
                this.tc = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.tb = showConnectingPopup;
                this.tc = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.td = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

