/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fm;

public final class GameEntity
extends fm
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new a();
    private final int kg;
    private final String kh;
    private final String qa;
    private final String sH;
    private final String sI;
    private final String sJ;
    private final String sK;
    private final Uri sL;
    private final Uri sM;
    private final Uri sN;
    private final boolean sO;
    private final boolean sP;
    private final String sQ;
    private final int sR;
    private final int sS;
    private final int sT;
    private final boolean sU;
    private final boolean sV;

    public GameEntity(Game game) {
        this.kg = 2;
        this.kh = game.getApplicationId();
        this.sH = game.getPrimaryCategory();
        this.sI = game.getSecondaryCategory();
        this.sJ = game.getDescription();
        this.sK = game.getDeveloperName();
        this.qa = game.getDisplayName();
        this.sL = game.getIconImageUri();
        this.sM = game.getHiResImageUri();
        this.sN = game.getFeaturedImageUri();
        this.sO = game.isPlayEnabledGame();
        this.sP = game.isInstanceInstalled();
        this.sQ = game.getInstancePackageName();
        this.sR = game.getGameplayAclStatus();
        this.sS = game.getAchievementTotalCount();
        this.sT = game.getLeaderboardCount();
        this.sU = game.isRealTimeMultiplayerEnabled();
        this.sV = game.isTurnBasedMultiplayerEnabled();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled) {
        this.kg = versionCode;
        this.kh = applicationId;
        this.qa = displayName;
        this.sH = primaryCategory;
        this.sI = secondaryCategory;
        this.sJ = description;
        this.sK = developerName;
        this.sL = iconImageUri;
        this.sM = hiResImageUri;
        this.sN = featuredImageUri;
        this.sO = playEnabledGame;
        this.sP = instanceInstalled;
        this.sQ = instancePackageName;
        this.sR = gameplayAclStatus;
        this.sS = achievementTotalCount;
        this.sT = leaderboardCount;
        this.sU = realTimeEnabled;
        this.sV = turnBasedEnabled;
    }

    public int getVersionCode() {
        return this.kg;
    }

    public String getApplicationId() {
        return this.kh;
    }

    public String getDisplayName() {
        return this.qa;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        fc.b(this.qa, dataOut);
    }

    public String getPrimaryCategory() {
        return this.sH;
    }

    public String getSecondaryCategory() {
        return this.sI;
    }

    public String getDescription() {
        return this.sJ;
    }

    public void getDescription(CharArrayBuffer dataOut) {
        fc.b(this.sJ, dataOut);
    }

    public String getDeveloperName() {
        return this.sK;
    }

    public void getDeveloperName(CharArrayBuffer dataOut) {
        fc.b(this.sK, dataOut);
    }

    public Uri getIconImageUri() {
        return this.sL;
    }

    public Uri getHiResImageUri() {
        return this.sM;
    }

    public Uri getFeaturedImageUri() {
        return this.sN;
    }

    public boolean isPlayEnabledGame() {
        return this.sO;
    }

    public boolean isInstanceInstalled() {
        return this.sP;
    }

    public String getInstancePackageName() {
        return this.sQ;
    }

    public int getGameplayAclStatus() {
        return this.sR;
    }

    public int getAchievementTotalCount() {
        return this.sS;
    }

    public int getLeaderboardCount() {
        return this.sT;
    }

    public boolean isRealTimeMultiplayerEnabled() {
        return this.sU;
    }

    public boolean isTurnBasedMultiplayerEnabled() {
        return this.sV;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return ee.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.isPlayEnabledGame(), game.isInstanceInstalled(), game.getInstancePackageName(), game.getGameplayAclStatus(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return ee.equal(game2.getApplicationId(), game.getApplicationId()) && ee.equal(game2.getDisplayName(), game.getDisplayName()) && ee.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && ee.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && ee.equal(game2.getDescription(), game.getDescription()) && ee.equal(game2.getDeveloperName(), game.getDeveloperName()) && ee.equal(game2.getIconImageUri(), game.getIconImageUri()) && ee.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && ee.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && ee.equal(game2.isPlayEnabledGame(), game.isPlayEnabledGame()) && ee.equal(game2.isInstanceInstalled(), game.isInstanceInstalled()) && ee.equal(game2.getInstancePackageName(), game.getInstancePackageName()) && ee.equal(game2.getGameplayAclStatus(), game.getGameplayAclStatus()) && ee.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && ee.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && ee.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && ee.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return ee.e(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("HiResImageUri", game.getHiResImageUri()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("PlayEnabledGame", game.isPlayEnabledGame()).a("InstanceInstalled", game.isInstanceInstalled()).a("InstancePackageName", game.getInstancePackageName()).a("GameplayAclStatus", game.getGameplayAclStatus()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.bN()) {
            com.google.android.gms.games.a.a(this, dest, flags);
        } else {
            dest.writeString(this.kh);
            dest.writeString(this.qa);
            dest.writeString(this.sH);
            dest.writeString(this.sI);
            dest.writeString(this.sJ);
            dest.writeString(this.sK);
            dest.writeString(this.sL == null ? null : this.sL.toString());
            dest.writeString(this.sM == null ? null : this.sM.toString());
            dest.writeString(this.sN == null ? null : this.sN.toString());
            dest.writeInt(this.sO ? 1 : 0);
            dest.writeInt(this.sP ? 1 : 0);
            dest.writeString(this.sQ);
            dest.writeInt(this.sR);
            dest.writeInt(this.sS);
            dest.writeInt(this.sT);
        }
    }

    static final class a
    extends com.google.android.gms.games.a {
        a() {
        }

        public GameEntity Y(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.bM());
            if (bl2 || GameEntity.P(GameEntity.class.getCanonicalName())) {
                return super.Y(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            Uri uri = string7 == null ? null : Uri.parse((String)string7);
            String string8 = parcel.readString();
            Uri uri2 = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri3 = string9 == null ? null : Uri.parse((String)string9);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string10 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            return new GameEntity(2, string, string2, string3, string4, string5, string6, uri, uri2, uri3, bl3, bl4, string10, n2, n3, n4, bl5, bl6);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.Y(x0);
        }
    }
}

