/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.CreateFileActivityBuilder;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveFolder;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataBuffer;
import com.google.android.gms.drive.OpenFileActivityBuilder;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.CreateContentsRequest;
import com.google.android.gms.drive.internal.GetMetadataRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnListEntriesResponse;
import com.google.android.gms.drive.internal.OnMetadataResponse;
import com.google.android.gms.drive.internal.QueryRequest;
import com.google.android.gms.drive.internal.l;
import com.google.android.gms.drive.internal.p;
import com.google.android.gms.drive.internal.z;
import com.google.android.gms.drive.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class h
implements DriveApi {
    @Override
    public PendingResult<DriveApi.MetadataBufferResult> query(GoogleApiClient apiClient, final Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be provided.");
        }
        return apiClient.a(new j(){

            protected void a(com.google.android.gms.drive.internal.j j2) {
                try {
                    j2.cN().a(new QueryRequest(query), (p)new i(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new f(new Status(8, remoteException.getLocalizedMessage(), null), null));
                }
            }
        });
    }

    @Override
    public PendingResult<DriveApi.ContentsResult> newContents(GoogleApiClient apiClient) {
        return apiClient.a(new h(){

            protected void a(com.google.android.gms.drive.internal.j j2) {
                try {
                    j2.cN().a(new CreateContentsRequest(), (p)new g(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new a(new Status(8, remoteException.getLocalizedMessage(), null), null));
                }
            }
        });
    }

    @Override
    public PendingResult<Status> discardContents(GoogleApiClient apiClient, final Contents contents) {
        return apiClient.b(new b(){

            protected void a(com.google.android.gms.drive.internal.j j2) {
                try {
                    j2.cN().a(new CloseContentsRequest(contents, false), (p)new z(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new Status(8, remoteException.getLocalizedMessage(), null));
                }
            }
        });
    }

    @Override
    public PendingResult<DriveApi.DriveIdResult> fetchDriveId(GoogleApiClient apiClient, final String resourceId) {
        return apiClient.a(new e(){

            protected void a(com.google.android.gms.drive.internal.j j2) {
                try {
                    j2.cN().a(new GetMetadataRequest(DriveId.ab(resourceId)), (p)new c(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new d(new Status(8, remoteException.getLocalizedMessage(), null), null));
                }
            }
        });
    }

    @Override
    public DriveFile getFile(GoogleApiClient apiClient, DriveId id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new com.google.android.gms.drive.internal.k(id2);
    }

    @Override
    public DriveFolder getFolder(GoogleApiClient apiClient, DriveId id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("Id must be provided.");
        }
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        return new l(id2);
    }

    @Override
    public DriveFolder getRootFolder(GoogleApiClient apiClient) {
        if (!apiClient.isConnected()) {
            throw new IllegalStateException("Client must be connected");
        }
        com.google.android.gms.drive.internal.j j2 = apiClient.a(Drive.jO);
        return new l(j2.cO());
    }

    @Override
    public OpenFileActivityBuilder newOpenFileActivityBuilder() {
        return new OpenFileActivityBuilder();
    }

    @Override
    public CreateFileActivityBuilder newCreateFileActivityBuilder() {
        return new CreateFileActivityBuilder();
    }

    @Override
    public PendingResult<Status> requestSync(GoogleApiClient client) {
        return client.b(new k(){

            protected void a(com.google.android.gms.drive.internal.j j2) {
                try {
                    j2.cN().a(new z(this));
                }
                catch (RemoteException remoteException) {
                    this.a(new Status(8, remoteException.getLocalizedMessage(), null));
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class g
    extends com.google.android.gms.drive.internal.a {
        private final a.c<DriveApi.ContentsResult> jW;

        public g(a.c<DriveApi.ContentsResult> c2) {
            this.jW = c2;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.jW.a(new a(Status.nA, onContentsResponse.cQ()));
        }

        @Override
        public void m(Status status) throws RemoteException {
            this.jW.a(new a(status, null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class c
    extends com.google.android.gms.drive.internal.a {
        private final a.c<DriveApi.DriveIdResult> jW;

        public c(a.c<DriveApi.DriveIdResult> c2) {
            this.jW = c2;
        }

        @Override
        public void a(OnMetadataResponse onMetadataResponse) throws RemoteException {
            this.jW.a(new d(Status.nA, new com.google.android.gms.drive.internal.g(onMetadataResponse.cU()).getDriveId()));
        }

        @Override
        public void m(Status status) throws RemoteException {
            this.jW.a(new d(status, null));
        }
    }

    static class d
    implements DriveApi.DriveIdResult {
        private final Status jY;
        private final DriveId qG;

        public d(Status status, DriveId driveId) {
            this.jY = status;
            this.qG = driveId;
        }

        public Status getStatus() {
            return this.jY;
        }

        public DriveId getDriveId() {
            return this.qG;
        }
    }

    static class a
    implements DriveApi.ContentsResult {
        private final Status jY;
        private final Contents qK;

        public a(Status status, Contents contents) {
            this.jY = status;
            this.qK = contents;
        }

        public Status getStatus() {
            return this.jY;
        }

        public Contents getContents() {
            return this.qK;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class k
    extends com.google.android.gms.drive.internal.i<Status> {
        k() {
        }

        public Status g(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.g(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class e
    extends com.google.android.gms.drive.internal.i<DriveApi.DriveIdResult> {
        e() {
        }

        public DriveApi.DriveIdResult n(Status status) {
            return new d(status, null);
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.n(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends com.google.android.gms.drive.internal.i<Status> {
        b() {
        }

        public Status g(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.g(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class h
    extends com.google.android.gms.drive.internal.i<DriveApi.ContentsResult> {
        h() {
        }

        public DriveApi.ContentsResult o(Status status) {
            return new a(status, null);
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.o(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class j
    extends com.google.android.gms.drive.internal.i<DriveApi.MetadataBufferResult> {
        j() {
        }

        public DriveApi.MetadataBufferResult p(Status status) {
            return new f(status, null);
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.p(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class i
    extends com.google.android.gms.drive.internal.a {
        private final a.c<DriveApi.MetadataBufferResult> jW;

        public i(a.c<DriveApi.MetadataBufferResult> c2) {
            this.jW = c2;
        }

        @Override
        public void a(OnListEntriesResponse onListEntriesResponse) throws RemoteException {
            MetadataBuffer metadataBuffer = new MetadataBuffer(onListEntriesResponse.cT(), null);
            this.jW.a(new f(Status.nA, metadataBuffer));
        }

        @Override
        public void m(Status status) throws RemoteException {
            this.jW.a(new f(status, null));
        }
    }

    static class f
    implements DriveApi.MetadataBufferResult {
        private final Status jY;
        private final MetadataBuffer rf;

        public f(Status status, MetadataBuffer metadataBuffer) {
            this.jY = status;
            this.rf = metadataBuffer;
        }

        public Status getStatus() {
            return this.jY;
        }

        public MetadataBuffer getMetadataBuffer() {
            return this.rf;
        }
    }
}

