/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.ee;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int kg;
    private final Uri oA;
    private final int w;
    private final int v;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.kg = versionCode;
        this.oA = url;
        this.w = width;
        this.v = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.f(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.kg;
    }

    private static Uri f(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.oA;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.v;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.w, this.v, this.oA.toString());
    }

    public JSONObject aP() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.oA.toString());
            jSONObject.put("width", this.w);
            jSONObject.put("height", this.v);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return dh.a(this.oA, webImage.oA) && this.w == webImage.w && this.v == webImage.v;
    }

    public int hashCode() {
        return ee.hashCode(this.oA, this.w, this.v);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

