/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.ek;
import com.google.android.gms.internal.fg;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object ob = new Object();
    private static HashSet<Uri> oc = new HashSet();
    private static ImageManager od;
    private static ImageManager oe;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService of;
    private final b og;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> oh;
    private final Map<Uri, ImageReceiver> oi;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (oe == null) {
                oe = new ImageManager(context, true);
            }
            return oe;
        }
        if (od == null) {
            od = new ImageManager(context, false);
        }
        return od;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.of = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.og = new b(this.mContext);
            if (fg.cG()) {
                this.bz();
            }
        } else {
            this.og = null;
        }
        this.oh = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.oi = new HashMap<Uri, ImageReceiver>();
    }

    private void bz() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.og));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, int resId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(resId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.F(defaultResId);
        a2.a(imageView);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.a(listener);
        this.a(a2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        com.google.android.gms.common.images.a a2 = new com.google.android.gms.common.images.a(uri);
        a2.F(defaultResId);
        a2.a(listener);
        this.a(a2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        ds.N("ImageManager.loadImage() must be called in the main thread");
        boolean bl2 = this.b(a2);
        d d2 = new d(a2);
        if (bl2) {
            d2.run();
        } else {
            this.mHandler.post((Runnable)d2);
        }
    }

    private boolean b(com.google.android.gms.common.images.a a2) {
        ds.N("ImageManager.cleanupHashMaps() must be called in the main thread");
        if (a2.os == 1) {
            return true;
        }
        ImageReceiver imageReceiver = this.oh.get(a2);
        if (imageReceiver == null) {
            return true;
        }
        if (imageReceiver.ok) {
            return false;
        }
        this.oh.remove(a2);
        imageReceiver.d(a2);
        return true;
    }

    private Bitmap a(a.a a2) {
        if (this.og == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.og.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class b
    extends ek<a.a, Bitmap> {
        public b(Context context) {
            super(b.q(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int q(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && fg.cD() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b og;

        public e(b b2) {
            this.og = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.og.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.og.evictAll();
            } else if (level >= 20) {
                this.og.trimToSize(this.og.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch mX;
        private boolean oo;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.oo = bl2;
            this.mX = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            ds.N("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.og != null) {
                if (this.oo) {
                    ImageManager.this.og.evictAll();
                    System.gc();
                    this.oo = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.og.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.oi.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.mX.countDown();
            Object object = ob;
            synchronized (object) {
                oc.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            imageReceiver.ok = true;
            ArrayList arrayList = imageReceiver.oj;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    a2.b(ImageManager.this.mContext, false);
                }
                if (a2.os == 1) continue;
                ImageManager.this.oh.remove(a2);
            }
            imageReceiver.ok = false;
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor om;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.om = parcelFileDescriptor;
        }

        public void run() {
            ds.O("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.om != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.om.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.om.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> oj;
        boolean ok;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.ok = false;
            this.mUri = uri;
            this.oj = new ArrayList();
        }

        public void c(com.google.android.gms.common.images.a a2) {
            ds.a(!this.ok, "Cannot add an ImageRequest when mHandlingRequests is true");
            ds.N("ImageReceiver.addImageRequest() must be called in the main thread");
            this.oj.add(a2);
        }

        public void d(com.google.android.gms.common.images.a a2) {
            ds.a(!this.ok, "Cannot remove an ImageRequest when mHandlingRequests is true");
            ds.N("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.oj.remove(a2);
        }

        public void bB() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.of.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a on;

        public d(com.google.android.gms.common.images.a a2) {
            this.on = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ds.N("LoadImageRunnable must be executed on the main thread");
            ImageManager.this.b(this.on);
            a.a a2 = this.on.op;
            if (a2.uri == null) {
                this.on.b(ImageManager.this.mContext, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.on.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            this.on.r(ImageManager.this.mContext);
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.oi.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.oi.put(a2.uri, imageReceiver);
            }
            imageReceiver.c(this.on);
            if (this.on.os != 1) {
                ImageManager.this.oh.put(this.on, imageReceiver);
            }
            boolean bl2 = false;
            Object object = ob;
            synchronized (object) {
                bl2 = oc.contains(a2.uri);
                if (!bl2) {
                    oc.add(a2.uri);
                    imageReceiver.bB();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

