/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.AbstractWindowedCursor;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.DataHolderCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.eg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataHolder
implements SafeParcelable {
    public static final DataHolderCreator CREATOR = new DataHolderCreator();
    private final int kg;
    private final String[] nK;
    Bundle nL;
    private final CursorWindow[] nM;
    private final int mC;
    private final Bundle nN;
    int[] nO;
    int nP;
    boolean mClosed = false;
    private Object nQ;
    private boolean nR = true;
    private static final Builder nS = new Builder(new String[0], null){

        @Override
        public Builder withRow(HashMap<String, Object> row) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public Builder withRow(ContentValues values) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.kg = versionCode;
        this.nK = columns;
        this.nM = windows;
        this.mC = statusCode;
        this.nN = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.kg = 1;
        this.nK = eg.f(columns);
        this.nM = eg.f(windows);
        this.mC = statusCode;
        this.nN = metadata;
        this.validateContents();
    }

    public void c(Object object) {
        this.nQ = object;
    }

    public DataHolder(AbstractWindowedCursor cursor, int statusCode, Bundle metadata) {
        this(cursor.getColumnNames(), DataHolder.a(cursor), statusCode, metadata);
    }

    private DataHolder(Builder builder, int statusCode, Bundle metadata) {
        this(builder.nK, DataHolder.a(builder, -1), statusCode, metadata);
    }

    private DataHolder(Builder builder, int statusCode, Bundle metadata, int maxResults) {
        this(builder.nK, DataHolder.a(builder, maxResults), statusCode, metadata);
    }

    public void validateContents() {
        int n2;
        this.nL = new Bundle();
        for (n2 = 0; n2 < this.nK.length; ++n2) {
            this.nL.putInt(this.nK[n2], n2);
        }
        this.nO = new int[this.nM.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.nM.length; ++i2) {
            this.nO[i2] = n2;
            int n3 = this.nM[i2].getStartPosition();
            int n4 = n2 - n3;
            n2 += this.nM[i2].getNumRows() - n4;
        }
        this.nP = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        DataHolderCreator.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.kg;
    }

    String[] bv() {
        return this.nK;
    }

    CursorWindow[] bw() {
        return this.nM;
    }

    public int getStatusCode() {
        return this.mC;
    }

    public Bundle getMetadata() {
        return this.nN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CursorWindow[] a(AbstractWindowedCursor abstractWindowedCursor) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n2 = abstractWindowedCursor.getCount();
            CursorWindow cursorWindow = abstractWindowedCursor.getWindow();
            int n3 = 0;
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                abstractWindowedCursor.setWindow(null);
                arrayList.add(cursorWindow);
                n3 = cursorWindow.getNumRows();
            }
            while (n3 < n2 && abstractWindowedCursor.moveToPosition(n3)) {
                CursorWindow cursorWindow2 = abstractWindowedCursor.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    abstractWindowedCursor.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    cursorWindow2.setStartPosition(n3);
                    abstractWindowedCursor.fillWindow(n3, cursorWindow2);
                }
                if (cursorWindow2.getNumRows() == 0) {
                    break;
                }
                arrayList.add(cursorWindow2);
                n3 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
            }
        }
        finally {
            abstractWindowedCursor.close();
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private static CursorWindow[] a(Builder builder, int n2) {
        if (builder.nK.length == 0) {
            return new CursorWindow[0];
        }
        List list = n2 < 0 || n2 >= builder.nT.size() ? builder.nT : builder.nT.subList(0, n2);
        int n3 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(builder.nK.length);
        try {
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(builder.nK.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                    n4 = 0;
                }
                Map map = (Map)list.get(i2);
                boolean bl2 = true;
                for (int i3 = 0; i3 < builder.nK.length && bl2; ++i3) {
                    String string2 = builder.nK[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl2 = cursorWindow.putNull(n4, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl2 = cursorWindow.putString((String)v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v2).longValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v2).intValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl3 = (Boolean)v2;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, n4, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v2, n4, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl2) {
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(builder.nK.length);
                    arrayList.add(cursorWindow);
                    n4 = 0;
                    --i2;
                    continue;
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i4 = 0; i4 < n5; ++i4) {
                ((CursorWindow)arrayList.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void b(String string2, int n2) {
        if (this.nL == null || !this.nL.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.nP) {
            throw new CursorIndexOutOfBoundsException(n2, this.nP);
        }
    }

    public boolean hasColumn(String column) {
        return this.nL.containsKey(column);
    }

    public long getLong(String column, int row, int windowIndex) {
        this.b(column, row);
        return this.nM[windowIndex].getLong(row, this.nL.getInt(column));
    }

    public int getInteger(String column, int row, int windowIndex) {
        this.b(column, row);
        return this.nM[windowIndex].getInt(row, this.nL.getInt(column));
    }

    public String getString(String column, int row, int windowIndex) {
        this.b(column, row);
        return this.nM[windowIndex].getString(row, this.nL.getInt(column));
    }

    public boolean getBoolean(String column, int row, int windowIndex) {
        this.b(column, row);
        Long l2 = this.nM[windowIndex].getLong(row, this.nL.getInt(column));
        return l2 == 1L;
    }

    public byte[] getByteArray(String column, int row, int windowIndex) {
        this.b(column, row);
        return this.nM[windowIndex].getBlob(row, this.nL.getInt(column));
    }

    public Uri parseUri(String column, int row, int windowIndex) {
        String string2 = this.getString(column, row, windowIndex);
        return string2 == null ? null : Uri.parse((String)string2);
    }

    public void copyToBuffer(String column, int row, int windowIndex, CharArrayBuffer dataOut) {
        this.b(column, row);
        this.nM[windowIndex].copyStringToBuffer(row, this.nL.getInt(column), dataOut);
    }

    public boolean hasNull(String column, int row, int windowIndex) {
        this.b(column, row);
        return this.nM[windowIndex].isNull(row, this.nL.getInt(column));
    }

    public int getCount() {
        return this.nP;
    }

    public int C(int n2) {
        int n3;
        eg.p(n2 >= 0 && n2 < this.nP);
        for (n3 = 0; n3 < this.nO.length; ++n3) {
            if (n2 >= this.nO[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.nO.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.nM.length; ++i2) {
                    this.nM[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.nR && this.nM.length > 0 && !this.isClosed()) {
                String string2 = this.nQ == null ? "internal object: " + this.toString() : this.nQ.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call close() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static Builder builder(String[] columns) {
        return new Builder(columns, null);
    }

    public static Builder builder(String[] columns, String uniqueColumn) {
        eg.f(uniqueColumn);
        return new Builder(columns, uniqueColumn);
    }

    public static DataHolder empty(int statusCode) {
        return DataHolder.empty(statusCode, null);
    }

    public static DataHolder empty(int statusCode, Bundle metadata) {
        return new DataHolder(nS, statusCode, metadata);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class a
    implements Comparator<HashMap<String, Object>> {
        private final String nY;

        a(String string2) {
            this.nY = eg.f(string2);
        }

        public int a(HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2) {
            Object object;
            Object object2 = eg.f(hashMap.get(this.nY));
            if (object2.equals(object = eg.f(hashMap2.get(this.nY)))) {
                return 0;
            }
            if (object2 instanceof Boolean) {
                return ((Boolean)object2).compareTo((Boolean)object);
            }
            if (object2 instanceof Long) {
                return ((Long)object2).compareTo((Long)object);
            }
            if (object2 instanceof Integer) {
                return ((Integer)object2).compareTo((Integer)object);
            }
            if (object2 instanceof String) {
                return ((String)object2).compareTo((String)object);
            }
            throw new IllegalArgumentException("Unknown type for lValue " + object2);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.a((HashMap)x0, (HashMap)x1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final String[] nK;
        private final ArrayList<HashMap<String, Object>> nT;
        private final String nU;
        private final HashMap<Object, Integer> nV;
        private boolean nW;
        private String nX;

        private Builder(String[] columns, String uniqueColumn) {
            this.nK = eg.f(columns);
            this.nT = new ArrayList();
            this.nU = uniqueColumn;
            this.nV = new HashMap();
            this.nW = false;
            this.nX = null;
        }

        public Builder withRow(HashMap<String, Object> row) {
            ds.d(row);
            if (this.nU != null) {
                this.a(row);
            }
            this.nT.add(row);
            this.nW = false;
            return this;
        }

        private void a(HashMap<String, Object> hashMap) {
            Object object = hashMap.get(this.nU);
            if (object == null) {
                return;
            }
            Integer n2 = this.nV.remove(object);
            if (n2 != null) {
                this.nT.remove(n2);
            }
            this.nV.put(object, this.nT.size());
        }

        public Builder withRow(ContentValues values) {
            ds.d(values);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(values.size());
            Set set = values.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.withRow(hashMap);
        }

        public Builder removeRowsWithValue(String column, Object value) {
            for (int i2 = this.nT.size() - 1; i2 >= 0; --i2) {
                if (!ee.equal(this.nT.get(i2).get(column), value)) continue;
                this.nT.remove(i2);
            }
            return this;
        }

        public Builder sort(String sortColumn) {
            ds.d(sortColumn);
            if (this.nW && sortColumn.equals(this.nX)) {
                return this;
            }
            Collections.sort(this.nT, new a(sortColumn));
            this.bx();
            this.nW = true;
            this.nX = sortColumn;
            return this;
        }

        private void bx() {
            if (this.nU != null) {
                this.nV.clear();
                int n2 = this.nT.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = this.nT.get(i2).get(this.nU);
                    if (object == null) continue;
                    this.nV.put(object, i2);
                }
            }
        }

        public int getCount() {
            return this.nT.size();
        }

        public DataHolder build(int statusCode) {
            return new DataHolder(this, statusCode, null);
        }

        public DataHolder build(int statusCode, Bundle metadata) {
            return new DataHolder(this, statusCode, metadata, -1);
        }

        public DataHolder build(int statusCode, Bundle metadata, int maxResults) {
            return new DataHolder(this, statusCode, metadata, maxResults);
        }
    }
}

