/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ee;

public final class Status
implements Result,
SafeParcelable {
    public static final Status nA = new Status(0, null, null);
    public static final Status nB = new Status(14, null, null);
    public static final Status nC = new Status(15, null, null);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int kg;
    private final int mC;
    private final String nD;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.kg = versionCode;
        this.mC = statusCode;
        this.nD = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent bs() {
        return this.mPendingIntent;
    }

    String bt() {
        return this.nD;
    }

    int getVersionCode() {
        return this.kg;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.mC <= 0;
    }

    public boolean isInterrupted() {
        return this.mC == 14;
    }

    public int getStatusCode() {
        return this.mC;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return ee.hashCode(this.kg, this.mC, this.nD, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.kg == status.kg && this.mC == status.mC && ee.equal(this.nD, status.nD) && ee.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String bh() {
        if (this.nD != null) {
            return this.nD;
        }
        return CommonStatusCodes.getStatusCodeString(this.mC);
    }

    public String toString() {
        return ee.e(this).a("statusCode", this.bh()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult bu() {
        return new ConnectionResult(this.mC, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    public Status getStatus() {
        return this;
    }
}

