/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.dx;
import com.google.android.gms.internal.eg;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleApiClient {
    private final Object mV = new Object();
    private final dx ne;
    final Queue<b<?>> nf = new LinkedList();
    private ConnectionResult ng;
    private int nh;
    private int ni = 4;
    private int nj;
    private final Bundle nk = new Bundle();
    private final Map<Api.b<?>, Api.a> nl = new HashMap();
    private boolean nm;
    final Set<b> nn = new HashSet<b>();
    private final a nc = new a(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void b(b b2) {
            Object object = GoogleApiClient.this.mV;
            synchronized (object) {
                GoogleApiClient.this.nn.remove(b2);
            }
        }
    };
    final ConnectionCallbacks no = new ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnected(Bundle connectionHint) {
            Object object = GoogleApiClient.this.mV;
            synchronized (object) {
                if (GoogleApiClient.this.ni == 1) {
                    if (connectionHint != null) {
                        GoogleApiClient.this.nk.putAll(connectionHint);
                    }
                    GoogleApiClient.this.bn();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onConnectionSuspended(int cause) {
            Object object = GoogleApiClient.this.mV;
            synchronized (object) {
                GoogleApiClient.this.A(cause);
                if (cause == 2) {
                    GoogleApiClient.this.connect();
                }
            }
        }
    };
    private final dx.b np = new dx.b(){

        public boolean bp() {
            return GoogleApiClient.this.nm;
        }

        public boolean isConnected() {
            return GoogleApiClient.this.isConnected();
        }

        public Bundle aU() {
            return null;
        }
    };

    private GoogleApiClient(Context context, dt commonSettings, Map<Api, ApiOptions> apis, Set<ConnectionCallbacks> connectedCallbacks, Set<OnConnectionFailedListener> onConnectionFailedListeners) {
        this.ne = new dx(context, this.np);
        for (ConnectionCallbacks object : connectedCallbacks) {
            this.ne.registerConnectionCallbacks(object);
        }
        for (OnConnectionFailedListener onConnectionFailedListener : onConnectionFailedListeners) {
            this.ne.registerConnectionFailedListener(onConnectionFailedListener);
        }
        for (Api api : apis.keySet()) {
            final Api.b<?> b2 = api.bj();
            ApiOptions apiOptions = apis.get(api);
            this.nl.put(b2, (Api.a)b2.b(context, commonSettings, apiOptions, this.no, new OnConnectionFailedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onConnectionFailed(ConnectionResult result) {
                    Object object = GoogleApiClient.this.mV;
                    synchronized (object) {
                        if (GoogleApiClient.this.ng == null || b2.getPriority() < GoogleApiClient.this.nh) {
                            GoogleApiClient.this.ng = result;
                            GoogleApiClient.this.nh = b2.getPriority();
                        }
                        GoogleApiClient.this.bn();
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bn() {
        Object object = this.mV;
        synchronized (object) {
            --this.nj;
            if (this.nj == 0) {
                if (this.ng != null) {
                    this.A(3);
                    this.ne.a(this.ng);
                    this.nm = false;
                } else {
                    this.ni = 2;
                    this.bo();
                    Bundle bundle = this.nk.isEmpty() ? null : this.nk;
                    this.ne.b(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Api.a, T extends a.a<? extends Result, A>> T a(T t2) {
        Object object = this.mV;
        synchronized (object) {
            if (this.isConnected()) {
                this.b(t2);
            } else {
                this.nf.add(t2);
            }
        }
        return t2;
    }

    public <A extends Api.a, T extends a.a<? extends Result, A>> T b(T t2) {
        eg.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        this.bo();
        this.a((b<A>)t2);
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends Api.a> void a(b<A> b2) {
        Object object = this.mV;
        synchronized (object) {
            eg.a(this.isConnected(), "GoogleApiClient is not connected yet.");
            eg.a(b2.bj() != null, "This task can not be executed or enqueued (it's probably a Batch or malformed)");
            if (b2 instanceof Releasable) {
                this.nn.add(b2);
                b2.a(this.nc);
            }
            A a2 = this.a(b2.bj());
            b2.b(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bo() {
        eg.a(this.isConnected(), "GoogleApiClient is not connected yet.");
        Object object = this.mV;
        synchronized (object) {
            while (!this.nf.isEmpty()) {
                this.a(this.nf.remove());
            }
        }
    }

    public <C extends Api.a> C a(Api.b<C> b2) {
        Api.a a2 = this.nl.get(b2);
        eg.b(a2, (Object)"Appropriate Api was not requested.");
        return (C)a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.mV;
        synchronized (object) {
            if (this.isConnected() || this.isConnecting()) {
                return;
            }
            this.nm = true;
            this.ng = null;
            this.ni = 1;
            this.nk.clear();
            this.nj = this.nl.size();
            for (Api.a a2 : this.nl.values()) {
                a2.connect();
            }
        }
    }

    public void disconnect() {
        this.A(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(int n2) {
        Object object = this.mV;
        synchronized (object) {
            if (this.ni != 3) {
                boolean bl2 = this.isConnected();
                this.ni = 3;
                if (n2 == -1) {
                    this.nf.clear();
                }
                for (b object2 : this.nn) {
                    if (!(object2 instanceof Releasable)) continue;
                    try {
                        ((Releasable)((Object)object2)).release();
                    }
                    catch (Exception exception) {
                        Log.w((String)"GoogleApiClient", (String)("Unable to release " + object2), (Throwable)exception);
                    }
                }
                this.nn.clear();
                this.nm = false;
                for (Api.a a2 : this.nl.values()) {
                    if (!a2.isConnected()) continue;
                    a2.disconnect();
                }
                this.nm = true;
                this.ni = 4;
                if (bl2) {
                    if (n2 != -1) {
                        this.ne.J(n2);
                    }
                    this.nm = false;
                }
            }
        }
    }

    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.mV;
        synchronized (object) {
            return this.ni == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.mV;
        synchronized (object) {
            return this.ni == 1;
        }
    }

    public void registerConnectionCallbacks(ConnectionCallbacks listener) {
        this.ne.registerConnectionCallbacks(listener);
    }

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks listener) {
        return this.ne.isConnectionCallbacksRegistered(listener);
    }

    public void unregisterConnectionCallbacks(ConnectionCallbacks listener) {
        this.ne.unregisterConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(OnConnectionFailedListener listener) {
        this.ne.registerConnectionFailedListener(listener);
    }

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener listener) {
        return this.ne.isConnectionFailedListenerRegistered(listener);
    }

    public void unregisterConnectionFailedListener(OnConnectionFailedListener listener) {
        this.ne.unregisterConnectionFailedListener(listener);
    }

    public static final class Builder {
        private String jG;
        private final Set<String> ns = new HashSet<String>();
        private int nt;
        private View nu;
        private String nv;
        private final Context mContext;
        private final Map<Api, ApiOptions> nw = new HashMap<Api, ApiOptions>();
        private final Set<ConnectionCallbacks> nx = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> ny = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.nv = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            eg.b(connectedListener, (Object)"Must provide a connected listener");
            this.nx.add(connectedListener);
            eg.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.ny.add(connectionFailedListener);
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.nx.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.ny.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.nu = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.ns.add(scope.br());
            return this;
        }

        public Builder addApi(Api api) {
            return this.addApi(api, null);
        }

        public Builder addApi(Api api, ApiOptions options) {
            this.nw.put(api, options);
            List<Scope> list = api.bk();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.ns.add(list.get(i2).br());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.jG = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.nt = gravityForPopups;
            return this;
        }

        public dt bq() {
            return new dt(this.jG, this.ns, this.nt, this.nu, this.nv);
        }

        public GoogleApiClient build() {
            return new GoogleApiClient(this.mContext, this.bq(), this.nw, this.nx, this.ny);
        }
    }

    public static interface ApiOptions {
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface b<A extends Api.a> {
        public Api.b<A> bj();

        public void b(A var1);

        public void a(a var1);
    }

    public static interface a {
        public void b(b var1);
    }
}

