/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.eh;
import com.google.android.gms.internal.ei;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mP;
    private View mQ;
    private View.OnClickListener mR = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mP);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        eg.a(buttonSize >= 0 && buttonSize < 3, "Unknown button size " + buttonSize);
        eg.a(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme " + colorScheme);
        this.mSize = buttonSize;
        this.mP = colorScheme;
        this.p(this.getContext());
    }

    private void p(Context context) {
        if (this.mQ != null) {
            this.removeView(this.mQ);
        }
        try {
            this.mQ = eh.d(context, this.mSize, this.mP);
        }
        catch (e.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.mQ = SignInButton.c(context, this.mSize, this.mP);
        }
        this.addView(this.mQ);
        this.mQ.setEnabled(this.isEnabled());
        this.mQ.setOnClickListener((View.OnClickListener)this);
    }

    private static Button c(Context context, int n2, int n3) {
        ei ei2 = new ei(context);
        ei2.a(context.getResources(), n2, n3);
        return ei2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mR = listener;
        if (this.mQ != null) {
            this.mQ.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mQ.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.mR != null && view == this.mQ) {
            this.mR.onClick((View)this);
        }
    }
}

