/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.dl;
import com.google.android.gms.internal.dm;
import com.google.android.gms.internal.dn;
import java.io.IOException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object fx = new Object();
    private final dl ld;
    private final a le = new a();
    private OnMetadataUpdatedListener lf;
    private OnStatusUpdatedListener lg;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_CANCELED = 2;
    public static final int STATUS_TIMED_OUT = 3;
    public static final int STATUS_REPLACED = 4;

    public RemoteMediaPlayer() {
        this.ld = new dl(){

            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.ld.a(this.le);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dg dg2) {
                Object object = RemoteMediaPlayer.this.fx;
                synchronized (object) {
                    RemoteMediaPlayer.this.le.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.ld.a(this.lv, mediaInfo, autoplay, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.k(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.le.b(null);
                    }
                }
            }
        });
    }

    public void pause(GoogleApiClient apiClient) throws IOException {
        this.pause(apiClient, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(GoogleApiClient apiClient, JSONObject customData) throws IOException {
        Object object = this.fx;
        synchronized (object) {
            this.le.b(apiClient);
            try {
                this.ld.c(customData);
            }
            finally {
                this.le.b(null);
            }
        }
    }

    public void stop(GoogleApiClient apiClient) throws IOException {
        this.stop(apiClient, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(GoogleApiClient apiClient, JSONObject customData) throws IOException {
        Object object = this.fx;
        synchronized (object) {
            this.le.b(apiClient);
            try {
                this.ld.d(customData);
            }
            finally {
                this.le.b(null);
            }
        }
    }

    public void play(GoogleApiClient apiClient) throws IOException, IllegalStateException {
        this.play(apiClient, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(GoogleApiClient apiClient, JSONObject customData) throws IOException, IllegalStateException {
        Object object = this.fx;
        synchronized (object) {
            this.le.b(apiClient);
            try {
                this.ld.e(customData);
            }
            finally {
                this.le.b(null);
            }
        }
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dg dg2) {
                Object object = RemoteMediaPlayer.this.fx;
                synchronized (object) {
                    RemoteMediaPlayer.this.le.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.ld.a(this.lv, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.k(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.le.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dg dg2) {
                Object object = RemoteMediaPlayer.this.fx;
                synchronized (object) {
                    RemoteMediaPlayer.this.le.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.ld.a(this.lv, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.a(this.k(new Status(1)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.a(this.k(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.a(this.k(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.le.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dg dg2) {
                Object object = RemoteMediaPlayer.this.fx;
                synchronized (object) {
                    RemoteMediaPlayer.this.le.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.ld.a(this.lv, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.a(this.k(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.a(this.k(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.le.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void a(dg dg2) {
                Object object = RemoteMediaPlayer.this.fx;
                synchronized (object) {
                    RemoteMediaPlayer.this.le.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.ld.a(this.lv);
                    }
                    catch (IOException iOException) {
                        this.a(this.k(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.le.b(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.fx;
        synchronized (object) {
            return this.ld.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.fx;
        synchronized (object) {
            return this.ld.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.fx;
        synchronized (object) {
            return this.ld.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.fx;
        synchronized (object) {
            return this.ld.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.lg = listener;
    }

    private void onStatusUpdated() {
        if (this.lg != null) {
            this.lg.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.lf = listener;
    }

    private void onMetadataUpdated() {
        if (this.lf != null) {
            this.lf.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.ld.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.ld.B(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends Cast.a<MediaChannelResult> {
        dn lv = new dn(){

            public void g(long l2) {
                b.this.a(b.this.k(new Status(4)));
            }

            public void a(long l2, int n2, JSONObject jSONObject) {
                b.this.a(new c(new Status(n2), jSONObject));
            }
        };

        b() {
        }

        public MediaChannelResult k(final Status status) {
            return new MediaChannelResult(){

                public Status getStatus() {
                    return status;
                }
            };
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.k(status);
        }
    }

    private static final class c
    implements MediaChannelResult {
        private final Status jY;
        private final JSONObject kM;

        c(Status status, JSONObject jSONObject) {
            this.jY = status;
            this.kM = jSONObject;
        }

        public Status getStatus() {
            return this.jY;
        }
    }

    public static interface MediaChannelResult
    extends Result {
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$a
    implements dm {
        private GoogleApiClient lr;
        private long ls = 0L;

        public void b(GoogleApiClient googleApiClient) {
            this.lr = googleApiClient;
        }

        public void a(String string2, String string3, long l2, String string4) throws IOException {
            if (this.lr == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.lr, string2, string3).setResultCallback(new a(l2));
        }

        public long aR() {
            return ++this.ls;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class a
        implements ResultCallback<Status> {
            private final long lt;

            a(long l2) {
                this.lt = l2;
            }

            public void j(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.ld.a(this.lt, status.getStatusCode());
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.j((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

