/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.ee;
import com.google.android.gms.internal.fe;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    private final String kH;
    private int kI;
    private String kJ;
    private MediaMetadata kK;
    private long kL;
    private JSONObject kM;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.kH = contentId;
        this.kI = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        this.kH = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.kI = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.kJ = json.getString("contentType");
        if (json.has("metadata")) {
            JSONObject jSONObject = json.getJSONObject("metadata");
            int n2 = jSONObject.getInt("metadataType");
            this.kK = new MediaMetadata(n2);
            this.kK.b(jSONObject);
        }
        this.kL = dh.b(json.optDouble("duration", 0.0));
        this.kM = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.kH;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.kI = streamType;
    }

    public int getStreamType() {
        return this.kI;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.kJ = contentType;
    }

    public String getContentType() {
        return this.kJ;
    }

    void a(MediaMetadata mediaMetadata) {
        this.kK = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.kK;
    }

    void f(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.kL = l2;
    }

    public long getStreamDuration() {
        return this.kL;
    }

    void a(JSONObject jSONObject) {
        this.kM = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.kM;
    }

    void aO() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.kH)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.kJ)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.kI == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject aP() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.kH);
            switch (this.kI) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.kJ != null) {
                jSONObject.put("contentType", (Object)this.kJ);
            }
            if (this.kK != null) {
                jSONObject.put("metadata", (Object)this.kK.aP());
            }
            jSONObject.put("duration", dh.h(this.kL));
            if (this.kM != null) {
                jSONObject.put("customData", (Object)this.kM);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.kM == null != (mediaInfo.kM == null)) {
            return false;
        }
        if (this.kM != null && mediaInfo.kM != null && !fe.d(this.kM, mediaInfo.kM)) {
            return false;
        }
        return dh.a(this.kH, mediaInfo.kH) && this.kI == mediaInfo.kI && dh.a(this.kJ, mediaInfo.kJ) && dh.a(this.kK, mediaInfo.kK) && this.kL == mediaInfo.kL;
    }

    public int hashCode() {
        return ee.hashCode(this.kH, this.kI, this.kJ, this.kK, this.kL, String.valueOf(this.kM));
    }

    public static class Builder {
        private final MediaInfo kN;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.kN = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.kN.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.kN.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.kN.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.kN.f(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.kN.a(customData);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.kN.aO();
            return this.kN;
        }
    }
}

