/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dh;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int kg;
    private String kz;
    String kA;
    private Inet4Address kB;
    private String kC;
    private String kD;
    private String kE;
    private int kF;
    private List<WebImage> kG;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons) {
        this.kg = versionCode;
        this.kz = deviceId;
        this.kA = hostAddress;
        if (this.kA != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.kA);
                if (inetAddress instanceof Inet4Address) {
                    this.kB = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.kB = null;
            }
        }
        this.kC = friendlyName;
        this.kD = modelName;
        this.kE = deviceVersion;
        this.kF = servicePort;
        this.kG = icons;
    }

    private CastDevice() {
        this(1, null, null, null, null, null, -1, new ArrayList<WebImage>());
    }

    int getVersionCode() {
        return this.kg;
    }

    public String getDeviceId() {
        return this.kz;
    }

    public Inet4Address getIpAddress() {
        return this.kB;
    }

    public String getFriendlyName() {
        return this.kC;
    }

    public String getModelName() {
        return this.kD;
    }

    public String getDeviceVersion() {
        return this.kE;
    }

    public int getServicePort() {
        return this.kF;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.kG);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.kG.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.kG.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.kG) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.kG.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.kG.isEmpty();
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.kC, this.kz);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return dh.a(this.kz, castDevice.kz) && dh.a(this.kB, castDevice.kB) && dh.a(this.kD, castDevice.kD) && dh.a(this.kC, castDevice.kC) && dh.a(this.kE, castDevice.kE) && this.kF == castDevice.kF && dh.a(this.kG, castDevice.kG);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return dh.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.kz == null ? 0 : this.kz.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }
}

