/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dg;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.eg;
import java.io.IOException;

public final class Cast {
    public static final int MAX_MESSAGE_LENGTH = 65536;
    public static final int MAX_NAMESPACE_LENGTH = 128;
    public static final String EXTRA_APP_NO_LONGER_RUNNING = "com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING";
    static final Api.b<dg> jO = new Api.b<dg>(){

        public dg c(Context context, dt dt2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            eg.b(apiOptions, (Object)"Setting the API options is required.");
            eg.b(apiOptions instanceof CastOptions, (Object)"Must provide valid CastOptions!");
            CastOptions castOptions = (CastOptions)apiOptions;
            return new dg(context, castOptions.ks, castOptions.ku, castOptions.kt, connectionCallbacks, onConnectionFailedListener);
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, dt dt2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.c(context, dt2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Api API = new Api(jO, new Scope[0]);
    public static final CastApi CastApi = new CastApi.a();

    private Cast() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CastApi {
        public void requestStatus(GoogleApiClient var1) throws IOException, IllegalStateException;

        public PendingResult<Status> sendMessage(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient var1, String var2, boolean var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2, String var3);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1, String var2);

        public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient var1);

        public PendingResult<Status> leaveApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1);

        public PendingResult<Status> stopApplication(GoogleApiClient var1, String var2);

        public void setVolume(GoogleApiClient var1, double var2) throws IOException, IllegalArgumentException, IllegalStateException;

        public double getVolume(GoogleApiClient var1) throws IllegalStateException;

        public void setMute(GoogleApiClient var1, boolean var2) throws IOException, IllegalStateException;

        public boolean isMute(GoogleApiClient var1) throws IllegalStateException;

        public ApplicationMetadata getApplicationMetadata(GoogleApiClient var1) throws IllegalStateException;

        public String getApplicationStatus(GoogleApiClient var1) throws IllegalStateException;

        public void setMessageReceivedCallbacks(GoogleApiClient var1, String var2, MessageReceivedCallback var3) throws IOException, IllegalStateException;

        public void removeMessageReceivedCallbacks(GoogleApiClient var1, String var2) throws IOException, IllegalStateException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class a
        implements CastApi {
            @Override
            public void requestStatus(GoogleApiClient client) throws IOException, IllegalStateException {
                try {
                    client.a(jO).aV();
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public PendingResult<Status> sendMessage(GoogleApiClient client, final String namespace, final String message) {
                return client.b(new b(){

                    protected void a(dg dg2) {
                        try {
                            dg2.a(namespace, message, this);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.r(2001);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId) {
                return client.b(new c(){

                    protected void a(dg dg2) {
                        try {
                            dg2.a(applicationId, false, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> launchApplication(GoogleApiClient client, final String applicationId, final boolean relaunchIfRunning) {
                return client.b(new c(){

                    protected void a(dg dg2) {
                        try {
                            dg2.a(applicationId, relaunchIfRunning, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId, final String sessionId) {
                return client.b(new c(){

                    protected void a(dg dg2) {
                        try {
                            dg2.b(applicationId, sessionId, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client, final String applicationId) {
                return client.b(new c(){

                    protected void a(dg dg2) {
                        try {
                            dg2.b(applicationId, null, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<ApplicationConnectionResult> joinApplication(GoogleApiClient client) {
                return client.b(new c(){

                    protected void a(dg dg2) {
                        try {
                            dg2.b(null, null, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> leaveApplication(GoogleApiClient client) {
                return client.b(new b(){

                    protected void a(dg dg2) {
                        try {
                            dg2.e(this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client) {
                return client.b(new b(){

                    protected void a(dg dg2) {
                        try {
                            dg2.a("", this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public PendingResult<Status> stopApplication(GoogleApiClient client, final String sessionId) {
                return client.b(new b(){

                    protected void a(dg dg2) {
                        if (TextUtils.isEmpty((CharSequence)sessionId)) {
                            this.c(2001, "IllegalArgument: sessionId cannot be null or empty");
                            return;
                        }
                        try {
                            dg2.a(sessionId, this);
                        }
                        catch (IllegalStateException illegalStateException) {
                            this.r(2001);
                        }
                        catch (RemoteException remoteException) {
                            this.r(8);
                        }
                    }
                });
            }

            @Override
            public void setVolume(GoogleApiClient client, double volume) throws IOException, IllegalArgumentException, IllegalStateException {
                try {
                    client.a(jO).a(volume);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public double getVolume(GoogleApiClient client) throws IllegalStateException {
                return client.a(jO).aW();
            }

            @Override
            public void setMute(GoogleApiClient client, boolean mute) throws IOException, IllegalStateException {
                try {
                    client.a(jO).n(mute);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public boolean isMute(GoogleApiClient client) throws IllegalStateException {
                return client.a(jO).isMute();
            }

            @Override
            public ApplicationMetadata getApplicationMetadata(GoogleApiClient client) throws IllegalStateException {
                return client.a(jO).getApplicationMetadata();
            }

            @Override
            public String getApplicationStatus(GoogleApiClient client) throws IllegalStateException {
                return client.a(jO).getApplicationStatus();
            }

            @Override
            public void setMessageReceivedCallbacks(GoogleApiClient client, String namespace, MessageReceivedCallback callbacks) throws IOException, IllegalStateException {
                try {
                    client.a(jO).a(namespace, callbacks);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }

            @Override
            public void removeMessageReceivedCallbacks(GoogleApiClient client, String namespace) throws IOException, IllegalStateException {
                try {
                    client.a(jO).C(namespace);
                }
                catch (RemoteException remoteException) {
                    throw new IOException("service error");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends a<Status> {
        private b() {
        }

        public Status g(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.g(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class c
    extends a<ApplicationConnectionResult> {
        private c() {
        }

        public ApplicationConnectionResult i(final Status status) {
            return new ApplicationConnectionResult(){

                public Status getStatus() {
                    return status;
                }

                public boolean getWasLaunched() {
                    return false;
                }

                public String getSessionId() {
                    return null;
                }

                public String getApplicationStatus() {
                    return null;
                }

                public ApplicationMetadata getApplicationMetadata() {
                    return null;
                }
            };
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.i(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class a<R extends Result>
    extends a.a<R, dg>
    implements PendingResult<R> {
        public a() {
            super(jO);
        }

        public void r(int n2) {
            this.a(this.e(new Status(n2)));
        }

        public void c(int n2, String string2) {
            this.a(this.e(new Status(n2, string2, null)));
        }
    }

    public static interface ApplicationConnectionResult
    extends Result {
        public ApplicationMetadata getApplicationMetadata();

        public String getApplicationStatus();

        public String getSessionId();

        public boolean getWasLaunched();
    }

    public static final class CastOptions
    implements GoogleApiClient.ApiOptions {
        final CastDevice ks;
        final Listener kt;
        private final int ku;

        private CastOptions(Builder builder) {
            this.ks = builder.kv;
            this.kt = builder.kw;
            this.ku = builder.kx;
        }

        public static Builder builder(CastDevice castDevice, Listener castListener) {
            return new Builder(castDevice, castListener);
        }

        public static final class Builder {
            CastDevice kv;
            Listener kw;
            private int kx;

            private Builder(CastDevice castDevice, Listener castListener) {
                this.kv = castDevice;
                this.kw = castListener;
                this.kx = 0;
            }

            public Builder setDebuggingEnabled() {
                this.kx |= 1;
                return this;
            }

            public CastOptions build() {
                return new CastOptions(this);
            }
        }
    }

    public static interface MessageReceivedCallback {
        public void onMessageReceived(CastDevice var1, String var2, String var3);
    }

    public static abstract class Listener {
        public void onApplicationStatusChanged() {
        }

        public void onApplicationDisconnected(int statusCode) {
        }

        public void onVolumeChanged() {
        }
    }
}

