/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.dc;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.eg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppStateManager {
    static final Api.b<dc> jO = new Api.b<dc>(){

        public dc a(Context context, dt dt2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new dc(context, connectionCallbacks, onConnectionFailedListener, dt2.bF(), dt2.bH().toArray(new String[0]));
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.a b(Context context, dt dt2, GoogleApiClient.ApiOptions apiOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.a(context, dt2, apiOptions, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_APP_STATE = new Scope("https://www.googleapis.com/auth/appstate");
    public static final Api API = new Api(jO, SCOPE_APP_STATE);

    private AppStateManager() {
    }

    public static dc a(GoogleApiClient googleApiClient) {
        eg.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        eg.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        dc dc2 = googleApiClient.a(jO);
        eg.a(dc2 != null, "GoogleApiClient is not configured to use the AppState API. Pass AppStateManager.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return dc2;
    }

    public static int getMaxStateSize(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).getMaxStateSize();
    }

    public static int getMaxNumKeys(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).getMaxNumKeys();
    }

    private static StateResult b(final Status status) {
        return new StateResult(){

            public Status getStatus() {
                return status;
            }

            public StateLoadedResult getLoadedResult() {
                return null;
            }

            public StateConflictResult getConflictResult() {
                return null;
            }
        };
    }

    public static void update(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        googleApiClient.b(new e(){

            protected void a(dc dc2) {
                dc2.a(null, stateKey, data);
            }
        });
    }

    public static PendingResult<StateResult> updateImmediate(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        return googleApiClient.b(new e(){

            protected void a(dc dc2) {
                dc2.a(this, stateKey, data);
            }
        });
    }

    public static PendingResult<StateDeletedResult> delete(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.b(new b(){

            protected void a(dc dc2) {
                dc2.a(this, stateKey);
            }

            public StateDeletedResult d(final Status status) {
                return new StateDeletedResult(){

                    public Status getStatus() {
                        return status;
                    }

                    public int getStateKey() {
                        return stateKey;
                    }
                };
            }

            public /* synthetic */ Result e(Status status) {
                return this.d(status);
            }
        });
    }

    public static PendingResult<StateResult> load(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.a(new e(){

            protected void a(dc dc2) {
                dc2.b(this, stateKey);
            }
        });
    }

    public static PendingResult<StateListResult> list(GoogleApiClient googleApiClient) {
        return googleApiClient.a(new c(){

            protected void a(dc dc2) {
                dc2.a(this);
            }
        });
    }

    public static PendingResult<StateResult> resolve(GoogleApiClient googleApiClient, final int stateKey, final String resolvedVersion, final byte[] resolvedData) {
        return googleApiClient.b(new e(){

            protected void a(dc dc2) {
                dc2.a(this, stateKey, resolvedVersion, resolvedData);
            }
        });
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.b(new d(){

            protected void a(dc dc2) {
                dc2.b(this);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class d
    extends a<Status> {
        private d() {
        }

        public Status g(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.g(status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class c
    extends a<StateListResult> {
        private c() {
        }

        public StateListResult f(final Status status) {
            return new StateListResult(){

                public Status getStatus() {
                    return status;
                }

                public AppStateBuffer getStateBuffer() {
                    return new AppStateBuffer(null);
                }
            };
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.f(status);
        }
    }

    public static interface StateListResult
    extends Result {
        public AppStateBuffer getStateBuffer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class b
    extends a<StateDeletedResult> {
        private b() {
        }
    }

    public static interface StateDeletedResult
    extends Result {
        public int getStateKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class e
    extends a<StateResult> {
        private e() {
        }

        public StateResult h(Status status) {
            return AppStateManager.b(status);
        }

        @Override
        public /* synthetic */ Result e(Status status) {
            return this.h(status);
        }
    }

    public static interface StateConflictResult
    extends Result {
        public int getStateKey();

        public String getResolvedVersion();

        public byte[] getLocalData();

        public byte[] getServerData();
    }

    public static interface StateLoadedResult
    extends Result {
        public int getStateKey();

        public byte[] getLocalData();
    }

    public static interface StateResult
    extends Result {
        public StateLoadedResult getLoadedResult();

        public StateConflictResult getConflictResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class a<R extends Result>
    extends a.a<R, dc>
    implements PendingResult<R> {
        public a() {
            super(jO);
        }
    }
}

