/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.admob;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import com.google.ads.AdRequest;
import com.google.ads.AdSize;
import com.google.ads.mediation.MediationAdRequest;
import com.google.ads.mediation.MediationBannerAdapter;
import com.google.ads.mediation.MediationBannerListener;
import com.google.ads.mediation.MediationInterstitialAdapter;
import com.google.ads.mediation.MediationInterstitialListener;
import com.google.ads.mediation.admob.AdMobServerParameters;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.mediation.admob.AdMobExtras;
import com.google.android.gms.internal.bg;
import com.google.android.gms.internal.cs;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdMobAdapter
implements MediationBannerAdapter<AdMobExtras, AdMobServerParameters>,
MediationInterstitialAdapter<AdMobExtras, AdMobServerParameters> {
    private AdView h;
    private InterstitialAd i;

    private static AdRequest a(Context context, MediationAdRequest mediationAdRequest, AdMobExtras adMobExtras, AdMobServerParameters adMobServerParameters) {
        String string22;
        Set<String> set;
        AdRequest.Gender gender;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((gender = mediationAdRequest.getGender()) != null) {
            builder.setGender(bg.a(gender));
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            for (String string22 : set) {
                builder.addKeyword(string22);
            }
        }
        if (mediationAdRequest.isTesting()) {
            builder.addTestDevice(cs.l(context));
        }
        if (adMobServerParameters.tagForChildDirectedTreatment != -1) {
            builder.tagForChildDirectedTreatment(adMobServerParameters.tagForChildDirectedTreatment == 1);
        }
        AdMobExtras adMobExtras2 = adMobExtras != null ? adMobExtras : new AdMobExtras(new Bundle());
        string22 = adMobExtras2.getExtras();
        string22.putInt("gw", 1);
        string22.putString("mad_hac", adMobServerParameters.allowHouseAds);
        if (!TextUtils.isEmpty((CharSequence)adMobServerParameters.adJson)) {
            string22.putString("_ad", adMobServerParameters.adJson);
        }
        string22.putBoolean("_noRefresh", true);
        builder.addNetworkExtras(adMobExtras2);
        return builder.build();
    }

    @Override
    public void destroy() {
        if (this.h != null) {
            this.h.destroy();
            this.h = null;
        }
        if (this.i != null) {
            this.i = null;
        }
    }

    @Override
    public Class<AdMobExtras> getAdditionalParametersType() {
        return AdMobExtras.class;
    }

    @Override
    public Class<AdMobServerParameters> getServerParametersType() {
        return AdMobServerParameters.class;
    }

    @Override
    public void requestBannerAd(MediationBannerListener bannerListener, Activity activity, AdMobServerParameters serverParameters, AdSize adSize, MediationAdRequest mediationAdRequest, AdMobExtras extras) {
        this.h = new AdView((Context)activity);
        this.h.setAdSize(new com.google.android.gms.ads.AdSize(adSize.getWidth(), adSize.getHeight()));
        this.h.setAdUnitId(serverParameters.adUnitId);
        this.h.setAdListener(new a(this, bannerListener));
        this.h.loadAd(AdMobAdapter.a((Context)activity, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public View getBannerView() {
        return this.h;
    }

    @Override
    public void requestInterstitialAd(MediationInterstitialListener interstitialListener, Activity activity, AdMobServerParameters serverParameters, MediationAdRequest mediationAdRequest, AdMobExtras extras) {
        this.i = new InterstitialAd((Context)activity);
        this.i.setAdUnitId(serverParameters.adUnitId);
        this.i.setAdListener(new b(this, interstitialListener));
        this.i.loadAd(AdMobAdapter.a((Context)activity, mediationAdRequest, extras, serverParameters));
    }

    @Override
    public void showInterstitial() {
        this.i.show();
    }

    private static final class b
    extends AdListener {
        private final AdMobAdapter j;
        private final MediationInterstitialListener l;

        public b(AdMobAdapter adMobAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.j = adMobAdapter;
            this.l = mediationInterstitialListener;
        }

        public void onAdLoaded() {
            this.l.onReceivedAd(this.j);
        }

        public void onAdFailedToLoad(int errorCode) {
            this.l.onFailedToReceiveAd(this.j, bg.h(errorCode));
        }

        public void onAdOpened() {
            this.l.onPresentScreen(this.j);
        }

        public void onAdClosed() {
            this.l.onDismissScreen(this.j);
        }

        public void onAdLeftApplication() {
            this.l.onLeaveApplication(this.j);
        }
    }

    private static final class a
    extends AdListener {
        private final AdMobAdapter j;
        private final MediationBannerListener k;

        public a(AdMobAdapter adMobAdapter, MediationBannerListener mediationBannerListener) {
            this.j = adMobAdapter;
            this.k = mediationBannerListener;
        }

        public void onAdLoaded() {
            this.k.onReceivedAd(this.j);
        }

        public void onAdFailedToLoad(int errorCode) {
            this.k.onFailedToReceiveAd(this.j, bg.h(errorCode));
        }

        public void onAdOpened() {
            this.k.onClick(this.j);
            this.k.onPresentScreen(this.j);
        }

        public void onAdClosed() {
            this.k.onDismissScreen(this.j);
        }

        public void onAdLeftApplication() {
            this.k.onLeaveApplication(this.j);
        }
    }
}

