/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.PendingIntent;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.go;
import com.google.android.gms.internal.gr;
import com.google.android.gms.plus.PlusOneButton;
import com.google.android.gms.plus.PlusOneDummyView;

public final class PlusOneButtonWithPopup
extends ViewGroup {
    private View zo;
    private int mSize;
    private int zp;
    private View.OnClickListener zu;
    private String iD;
    private String jD;

    public PlusOneButtonWithPopup(Context context) {
        this(context, null);
    }

    public PlusOneButtonWithPopup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.zp = PlusOneButton.getAnnotation(context, attrs);
        this.zo = new PlusOneDummyView(context, this.mSize);
        this.addView(this.zo);
    }

    private void eq() {
        if (this.zo != null) {
            this.removeView(this.zo);
        }
        this.zo = gr.a(this.getContext(), this.mSize, this.zp, this.iD, this.jD);
        if (this.zu != null) {
            this.setOnClickListener(this.zu);
        }
        this.addView(this.zo);
    }

    public void initialize(String url, String accountName) {
        du.c(url, "Url must not be null");
        this.iD = url;
        this.jD = accountName;
        this.eq();
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zu = onClickListener;
        this.zo.setOnClickListener(onClickListener);
    }

    public void setAnnotation(int annotation) {
        this.zp = annotation;
        this.eq();
    }

    public void setSize(int size) {
        this.mSize = size;
        this.eq();
    }

    public PendingIntent getResolution() {
        if (this.zo != null) {
            try {
                return this.er().getResolution();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public void cancelClick() {
        if (this.zo != null) {
            try {
                this.er().cancelClick();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public void reinitialize() {
        if (this.zo != null) {
            try {
                this.er().reinitialize();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private go er() throws RemoteException {
        IBinder iBinder = (IBinder)this.zo.getTag();
        go go2 = go.a.at(iBinder);
        if (go2 == null) {
            if (Log.isLoggable((String)"PlusOneButtonWithPopup", (int)5)) {
                Log.w((String)"PlusOneButtonWithPopup", (String)"Failed to get PlusOneDelegate");
            }
            throw new RemoteException();
        }
        return go2;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = this.getPaddingLeft() + this.getPaddingRight();
        int n3 = this.getPaddingTop() + this.getPaddingBottom();
        this.zo.measure(this.c(widthMeasureSpec, n2), this.c(heightMeasureSpec, n3));
        this.setMeasuredDimension(this.zo.getMeasuredWidth() + n2, this.zo.getMeasuredHeight() + n3);
    }

    private int c(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        switch (n4) {
            case -2147483648: 
            case 0x40000000: {
                int n5 = View.MeasureSpec.getSize((int)n2) - n3;
                return View.MeasureSpec.makeMeasureSpec((int)n5, (int)n4);
            }
        }
        return n2;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.zo.layout(this.getPaddingLeft(), this.getPaddingTop(), right - left - this.getPaddingRight(), bottom - top - this.getPaddingBottom());
    }
}

