/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptionsCreator;
import com.google.android.gms.maps.model.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolylineOptions
implements SafeParcelable {
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    private final int kZ;
    private final List<LatLng> yR;
    private float yx = 10.0f;
    private int kn = -16777216;
    private float ys = 0.0f;
    private boolean yt = true;
    private boolean yT = false;

    public PolylineOptions() {
        this.kZ = 1;
        this.yR = new ArrayList<LatLng>();
    }

    PolylineOptions(int versionCode, List points, float width, int color, float zIndex, boolean visible, boolean geodesic) {
        this.kZ = versionCode;
        this.yR = points;
        this.yx = width;
        this.kn = color;
        this.ys = zIndex;
        this.yt = visible;
        this.yT = geodesic;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eh()) {
            h.a(this, out, flags);
        } else {
            PolylineOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    int getVersionCode() {
        return this.kZ;
    }

    public PolylineOptions add(LatLng point) {
        this.yR.add(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        this.yR.addAll(Arrays.asList(points));
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.yR.add(latLng);
        }
        return this;
    }

    public PolylineOptions width(float width) {
        this.yx = width;
        return this;
    }

    public PolylineOptions color(int color) {
        this.kn = color;
        return this;
    }

    public PolylineOptions zIndex(float zIndex) {
        this.ys = zIndex;
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.yt = visible;
        return this;
    }

    public PolylineOptions geodesic(boolean geodesic) {
        this.yT = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.yR;
    }

    public float getWidth() {
        return this.yx;
    }

    public int getColor() {
        return this.kn;
    }

    public float getZIndex() {
        return this.ys;
    }

    public boolean isVisible() {
        return this.yt;
    }

    public boolean isGeodesic() {
        return this.yT;
    }
}

