/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int kZ;
    private final List<LatLng> yR;
    private final List<List<LatLng>> yS;
    private float yp = 10.0f;
    private int yq = -16777216;
    private int yr = 0;
    private float ys = 0.0f;
    private boolean yt = true;
    private boolean yT = false;

    public PolygonOptions() {
        this.kZ = 1;
        this.yR = new ArrayList<LatLng>();
        this.yS = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.kZ = versionCode;
        this.yR = points;
        this.yS = holes;
        this.yp = strokeWidth;
        this.yq = strokeColor;
        this.yr = fillColor;
        this.ys = zIndex;
        this.yt = visible;
        this.yT = geodesic;
    }

    int getVersionCode() {
        return this.kZ;
    }

    List el() {
        return this.yS;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eh()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.yR.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.yR.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.yR.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.yS.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.yp = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.yq = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.yr = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.ys = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.yt = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.yT = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.yR;
    }

    public List<List<LatLng>> getHoles() {
        return this.yS;
    }

    public float getStrokeWidth() {
        return this.yp;
    }

    public int getStrokeColor() {
        return this.yq;
    }

    public int getFillColor() {
        return this.yr;
    }

    public float getZIndex() {
        return this.ys;
    }

    public boolean isVisible() {
        return this.yt;
    }

    public boolean isGeodesic() {
        return this.yT;
    }
}

