/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.du;
import com.google.android.gms.maps.internal.r;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBoundsCreator;
import com.google.android.gms.maps.model.d;

public final class LatLngBounds
implements SafeParcelable {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int kZ;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        du.c(southwest, "null southwest");
        du.c(northeast, "null northeast");
        du.a(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.kZ = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    int getVersionCode() {
        return this.kZ;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (r.eh()) {
            d.a(this, out, flags);
        } else {
            LatLngBoundsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.b(d5, d6) < LatLngBounds.c(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    public LatLng getCenter() {
        double d2 = (this.southwest.latitude + this.northeast.latitude) / 2.0;
        double d3 = this.southwest.longitude;
        double d4 = this.northeast.longitude;
        double d5 = d3 <= d4 ? (d4 + d3) / 2.0 : (d4 + 360.0 + d3) / 2.0;
        return new LatLng(d2, d5);
    }

    private static double b(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double c(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return ds.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o2;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return ds.e(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double yD = Double.POSITIVE_INFINITY;
        private double yE = Double.NEGATIVE_INFINITY;
        private double yF = Double.NaN;
        private double yG = Double.NaN;

        public Builder include(LatLng point) {
            this.yD = Math.min(this.yD, point.latitude);
            this.yE = Math.max(this.yE, point.latitude);
            double d2 = point.longitude;
            if (Double.isNaN(this.yF)) {
                this.yF = d2;
                this.yG = d2;
            } else if (!this.b(d2)) {
                if (LatLngBounds.b(this.yF, d2) < LatLngBounds.c(this.yG, d2)) {
                    this.yF = d2;
                } else {
                    this.yG = d2;
                }
            }
            return this;
        }

        private boolean b(double d2) {
            if (this.yF <= this.yG) {
                return this.yF <= d2 && d2 <= this.yG;
            }
            return this.yF <= d2 || d2 <= this.yG;
        }

        public LatLngBounds build() {
            du.a(!Double.isNaN(this.yF), "no included points");
            return new LatLngBounds(new LatLng(this.yD, this.yF), new LatLng(this.yE, this.yG));
        }
    }
}

